/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.emulator.manager.platform.custom;

import java.util.ArrayList;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import org.tizen.emulator.manager.devices.DeviceTemplate;
import org.tizen.emulator.manager.platform.Platform;
import org.tizen.emulator.manager.platform.PlatformStringResources;
import org.tizen.emulator.manager.platform.Profile;
import org.tizen.emulator.manager.platform.Skin;
import org.tizen.emulator.manager.platform.Version;
import org.tizen.emulator.manager.platform.custom.CustomPlatformImageValue;
import org.tizen.emulator.manager.plugin.EMPlugin;
import org.tizen.emulator.manager.vms.VMProperty;
import org.tizen.emulator.manager.vms.type.Architecture;
import org.tizen.emulator.manager.vms.type.RESOLUTION;
import org.tizen.emulator.manager.vms.type.SKIN_SHAPE;

public class CustomPlatform
extends Platform {
    protected Platform basePlatform = null;

    public CustomPlatform(CustomPlatformImageValue value) {
        super(value.getImageFormat());
        this.setValue(value);
    }

    void setValue(CustomPlatformImageValue value) {
        this.basePlatform = value.getPlatform();
        this.setName(value.getName());
        for (String path : value.getPathList()) {
            this.addImagePath(path);
        }
        this.setImageType(value.getType());
        this.setImageDescription(value.getDescription());
    }

    public Platform getBasePlatform() {
        return this.basePlatform;
    }

    @Override
    public String getPlatformPath() {
        if (this.basePlatform == null) {
            return "";
        }
        return this.basePlatform.getPlatformPath();
    }

    @Override
    public Profile getProfile() {
        if (this.basePlatform == null) {
            return null;
        }
        return this.basePlatform.getProfile();
    }

    @Override
    public Version getVersion() {
        if (this.basePlatform == null) {
            return null;
        }
        return this.basePlatform.getVersion();
    }

    @Override
    public String getExtension() {
        if (this.basePlatform == null) {
            return "";
        }
        return this.basePlatform.getExtension();
    }

    @Override
    public String getEmulatorDirPath() {
        if (this.basePlatform == null) {
            return null;
        }
        return this.basePlatform.getEmulatorDirPath();
    }

    @Override
    public Architecture getImageArch() {
        if (this.basePlatform == null) {
            return Architecture.x86;
        }
        return this.basePlatform.getImageArch();
    }

    @Override
    public SKIN_SHAPE getImageSkinShape() {
        if (this.basePlatform == null) {
            return SKIN_SHAPE.NONE;
        }
        return this.basePlatform.getImageSkinShape();
    }

    @Override
    public EMPlugin getPlugin() {
        if (this.basePlatform == null) {
            return null;
        }
        return this.basePlatform.getPlugin();
    }

    @Override
    public String getImageBinaryVersion() {
        return PlatformStringResources.CUSTOM_IMAGE_VERSION;
    }

    @Override
    public List<Skin> getSkinList() {
        if (this.basePlatform == null) {
            return new ArrayList<Skin>();
        }
        return this.basePlatform.getSkinList();
    }

    @Override
    public Skin getSkinByPath(String path) {
        if (this.basePlatform == null) {
            return null;
        }
        return this.basePlatform.getSkinByPath(path);
    }

    @Override
    public Skin getSkinByName(String name) {
        if (this.basePlatform == null) {
            return null;
        }
        return this.basePlatform.getSkinByName(name);
    }

    @Override
    public SortedSet<Skin> getSkinList(RESOLUTION resolution) {
        if (this.basePlatform == null) {
            return new TreeSet<Skin>();
        }
        return this.basePlatform.getSkinList(resolution);
    }

    @Override
    public Skin getAvailableSkin(RESOLUTION resolution) {
        if (this.basePlatform == null) {
            return null;
        }
        return this.basePlatform.getAvailableSkin(resolution);
    }

    @Override
    public VMProperty getDefaultProperty() {
        if (this.basePlatform == null) {
            return null;
        }
        return this.basePlatform.getDefaultProperty();
    }

    @Override
    public void loadDeviceTemplates() {
        if (this.basePlatform == null) {
            return;
        }
        this.basePlatform.loadDeviceTemplates();
    }

    @Override
    public SortedSet<DeviceTemplate> getAvailableDeviceTemplates(boolean refresh) {
        if (this.basePlatform == null) {
            return new TreeSet<DeviceTemplate>();
        }
        return this.basePlatform.getAvailableDeviceTemplates(refresh);
    }

    @Override
    public SortedSet<DeviceTemplate> getDeviceTemplates() {
        if (this.basePlatform == null) {
            return new TreeSet<DeviceTemplate>();
        }
        return this.basePlatform.getDeviceTemplates();
    }

    @Override
    public void addDeviceTemplate(DeviceTemplate template) {
        if (this.basePlatform == null) {
            return;
        }
        this.basePlatform.addDeviceTemplate(template);
    }

    @Override
    public void removeDeviceTemplate(DeviceTemplate template) {
        if (this.basePlatform == null) {
            return;
        }
        this.basePlatform.removeDeviceTemplate(template);
    }
}

