/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.emulator.manager.vms.option;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import org.tizen.emulator.manager.logging.EMLogger;
import org.tizen.emulator.manager.vms.VMProperty;
import org.tizen.emulator.manager.vms.exception.VMLauncherException;
import org.tizen.emulator.manager.vms.option.IOption;
import org.tizen.emulator.manager.vms.option.OPTION_KEY;

public abstract class Option
implements IOption {
    protected final String DISPLAY = "-display";
    private static Map<Class<? extends IOption>, IOption> instanceMap = new HashMap<Class<? extends IOption>, IOption>();

    public static <T> IOption getInstance(Class<? extends IOption> type) {
        IOption opt = instanceMap.get(type);
        if (opt == null) {
            try {
                opt = type.newInstance();
                instanceMap.put(type, opt);
            }
            catch (InstantiationException e) {
                EMLogger.getLogger().log(Level.SEVERE, e.getMessage());
            }
            catch (IllegalAccessException e) {
                EMLogger.getLogger().log(Level.SEVERE, e.getMessage());
            }
        }
        return opt;
    }

    public static String varForm(OPTION_KEY key) {
        return "${" + key.toString() + "}";
    }

    public static String varForm(String var) {
        return "${" + var + "}";
    }

    public static boolean checkOnOff(String value) {
        if (value.toLowerCase().equals("on")) {
            return true;
        }
        if (value.toLowerCase().equals("off")) {
            return false;
        }
        return value.isEmpty();
    }

    public boolean checkOn(String value) {
        return value.toLowerCase().equals("on");
    }

    public boolean checkOnOrEmpty(String value) {
        return Option.checkOnOff(value);
    }

    @Override
    public void checkArgument(VMProperty property) throws VMLauncherException {
    }

    public static boolean isGreaterThanOrEqualTo(String ver1, String ver2) {
        return ver1.compareTo(ver2) >= 0;
    }

    public static boolean isLesserThan(String ver1, String ver2) {
        return ver1.compareTo(ver2) < 0;
    }

    public static boolean isEqual(String ver1, String ver2) {
        return ver1.equals(ver2);
    }
}

