/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.emulator.manager.ui.dialog;

import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.StringProperty;
import javafx.collections.ObservableList;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonBar;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import org.tizen.emulator.manager.tool.OSUtil;

public class CustomButtonBar
extends ButtonBar {
    private final HBox buttonPanel;
    private final DoubleProperty buttonPrefHeightProperty = new SimpleDoubleProperty((Object)this, "buttonPrefHeightProperty");

    public CustomButtonBar(HBox hbox, int buttonBarPrefHeight) {
        this.buttonPanel = hbox;
        this.buttonPanel.setPrefHeight((double)buttonBarPrefHeight);
        this.setButtonMinWidth(86.0);
        if (OSUtil.isMac()) {
            this.setButtonOrder("L_HE+U+FBIX_NCYOA_R");
        } else if (OSUtil.isLinux()) {
            this.setButtonOrder("L_HE+UNYACBXIO_R");
        } else {
            this.setButtonOrder("L_E+U+FBXI_YNOCAH_R");
        }
    }

    public HBox getButtonPanel() {
        return this.buttonPanel;
    }

    public void layoutButtons() {
        int i;
        ObservableList buttons = this.getButtons();
        this.buttonPanel.getChildren().clear();
        StringProperty buttonOrderProperty = this.buttonOrderProperty();
        char[] buttonOrderArr = ((String)buttonOrderProperty.get()).toCharArray();
        Spacer spacer = Spacer.NONE;
        block0: for (i = 0; i < buttonOrderArr.length; ++i) {
            char type = buttonOrderArr[i];
            if (type == '+') {
                spacer = spacer.replace(Spacer.DYNAMIC);
                continue;
            }
            if (type == '_') {
                spacer = spacer.replace(Spacer.FIXED);
                continue;
            }
            for (Node button : buttons) {
                ButtonBar.ButtonData data;
                if (button == null || (data = CustomButtonBar.getButtonData((Node)button)) == null || data.getTypeCode().indexOf(type) != 0) continue;
                spacer.add((Pane)this.buttonPanel, true);
                this.sizeButton(button);
                this.buttonPanel.getChildren().add((Object)button);
                HBox.setMargin((Node)button, (Insets)new Insets(0.0, 0.0, 0.0, 10.0));
                HBox.setHgrow((Node)button, (Priority)Priority.NEVER);
                spacer = spacer.replace(Spacer.NONE);
                continue block0;
            }
        }
        for (i = 0; i < buttons.size(); ++i) {
            Node btn = (Node)buttons.get(i);
            ButtonBar.ButtonData btnData = CustomButtonBar.getButtonData((Node)btn);
            if (btnData == null || !btnData.isDefaultButton()) continue;
            btn.requestFocus();
            break;
        }
    }

    public final void setButtonPrefHeight(double value) {
        this.buttonPrefHeightProperty.set(value);
    }

    private void sizeButton(Node btn) {
        if (btn instanceof Button) {
            Button regionBtn = (Button)btn;
            regionBtn.setPrefWidth(this.buttonMinWidthProperty().get());
            regionBtn.setPrefHeight(this.buttonPrefHeightProperty.get());
        }
    }

    private static enum Spacer {
        FIXED{

            @Override
            protected Node create(boolean edgeCase) {
                if (edgeCase) {
                    return null;
                }
                Region spacer = new Region();
                CustomButtonBar.setButtonData((Node)spacer, (ButtonBar.ButtonData)ButtonBar.ButtonData.SMALL_GAP);
                spacer.setMinWidth(10.0);
                HBox.setHgrow((Node)spacer, (Priority)Priority.NEVER);
                return spacer;
            }
        }
        ,
        DYNAMIC{

            @Override
            protected Node create(boolean edgeCase) {
                Region spacer = new Region();
                CustomButtonBar.setButtonData((Node)spacer, (ButtonBar.ButtonData)ButtonBar.ButtonData.BIG_GAP);
                spacer.setMinWidth(edgeCase ? 0.0 : 10.0);
                HBox.setHgrow((Node)spacer, (Priority)Priority.ALWAYS);
                return spacer;
            }

            @Override
            public Spacer replace(Spacer spacer) {
                return FIXED == spacer ? this : spacer;
            }
        }
        ,
        NONE;


        protected Node create(boolean edgeCase) {
            return null;
        }

        public Spacer replace(Spacer spacer) {
            return spacer;
        }

        public void add(Pane pane, boolean edgeCase) {
            Node spacer = this.create(edgeCase);
            if (spacer != null) {
                pane.getChildren().add((Object)spacer);
            }
        }
    }
}

