/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.emulator.manager.ui.dialog.network;

import java.util.Optional;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.ButtonType;
import javafx.scene.layout.VBox;
import javafx.util.Callback;
import org.tizen.emulator.manager.network.NetworkUtil;
import org.tizen.emulator.manager.tool.OSUtil;
import org.tizen.emulator.manager.ui.Messages;
import org.tizen.emulator.manager.ui.dialog.CustomDialog;
import org.tizen.emulator.manager.ui.dialog.network.TapDeviceReturn;
import org.tizen.emulator.manager.ui.tabview.event.Event;
import org.tizen.emulator.manager.ui.tabview.event.EventHandler;
import org.tizen.emulator.manager.ui.tabview.event.EventType;
import org.tizen.emulator.manager.ui.tabview.item.ComboViewItem;
import org.tizen.emulator.manager.ui.tabview.item.TextViewItem;

public class TapDeviceDialogForWin {
    private static Double WIDTH = 350.0;
    private static Double ITEM_HEIGHT = 28.0;
    private static Double TITLE_WIDTH = 80.0;
    private static String TITLE = Messages.getString("TapDeviceDialog.Title");
    private String tapName;
    private String ifName;
    private CustomDialog<TapDeviceReturn> dialog = new CustomDialog();
    private VBox box;

    public String getTapName() {
        return this.tapName;
    }

    public String getInterfaceName() {
        return this.ifName;
    }

    public TapDeviceDialogForWin() {
        this.dialog.setTitle(TITLE);
        this.dialog.getDialogPane().getButtonTypes().add((Object)ButtonType.OK);
        this.dialog.getDialogPane().getButtonTypes().add((Object)ButtonType.CANCEL);
        this.dialog.setResultConverter((Callback)new Callback<ButtonType, TapDeviceReturn>(){

            public TapDeviceReturn call(ButtonType arg0) {
                TapDeviceReturn re = new TapDeviceReturn();
                re.setButtonType(arg0);
                re.setTapName(TapDeviceDialogForWin.this.tapName);
                re.setHostNetName(TapDeviceDialogForWin.this.ifName);
                return re;
            }
        });
        this.makeBody();
        this.dialog.getDialogPane().setContent((Node)this.box);
    }

    public TapDeviceReturn open() {
        Optional optType = this.dialog.showAndWait();
        if (optType.isPresent()) {
            return (TapDeviceReturn)optType.get();
        }
        return null;
    }

    public void makeBody() {
        this.box = new VBox();
        TextViewItem inputName = new TextViewItem();
        inputName.setPrefWidth(WIDTH);
        inputName.setPrefHeight(ITEM_HEIGHT);
        inputName.setTitleMinWidth(TITLE_WIDTH);
        inputName.removeStateLabel();
        inputName.setTitle("Tap Name");
        inputName.setText(NetworkUtil.getAvailableTapName());
        inputName.setEnable(false);
        this.tapName = inputName.getText();
        this.box.getChildren().add((Object)inputName.getContent());
        VBox.setMargin((Node)inputName.getContent(), (Insets)new Insets(5.0, 10.0, 5.0, 10.0));
        if (!OSUtil.isWin8AndAbove()) {
            this.addHostNetworkItem();
        }
    }

    private void addHostNetworkItem() {
        ComboViewItem combo = new ComboViewItem();
        combo.setPrefWidth(WIDTH);
        combo.setPrefHeight(ITEM_HEIGHT);
        combo.setTitleMinWidth(TITLE_WIDTH);
        combo.removeStateLabel();
        combo.setTitle("Host Network");
        for (String str : NetworkUtil.getHostEthernetList()) {
            combo.addItem(str);
        }
        combo.selectItem(0);
        this.ifName = combo.getSelectedItem();
        combo.addEventHandler(EventType.Selection, new EventHandler<Event>(){

            @Override
            public void handleEvent(Event event) {
                TapDeviceDialogForWin.this.ifName = event.text;
            }
        });
        this.box.getChildren().add((Object)combo.getContent());
        VBox.setMargin((Node)combo.getContent(), (Insets)new Insets(5.0, 10.0, 5.0, 10.0));
    }
}

