/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.emulator.manager.ui.tabview.item;

import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.ButtonType;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import org.tizen.emulator.manager.tool.OSUtil;
import org.tizen.emulator.manager.ui.control.ImageButton;
import org.tizen.emulator.manager.ui.dialog.network.TapCreateWorkerDialog;
import org.tizen.emulator.manager.ui.dialog.network.TapDeviceDialogForWin;
import org.tizen.emulator.manager.ui.dialog.network.TapDeviceReturn;
import org.tizen.emulator.manager.ui.resources.ImageKind;
import org.tizen.emulator.manager.ui.tabview.event.Event;
import org.tizen.emulator.manager.ui.tabview.event.EventType;
import org.tizen.emulator.manager.ui.tabview.item.ComboViewItem;

public class NetTapDeviceViewItem
extends ComboViewItem {
    private ImageButton tapButton;
    private String newTap = "";
    private EventHandler<MouseEvent> actionHandler = new EventHandler<MouseEvent>(){

        public void handle(MouseEvent arg0) {
            TapDeviceReturn re = new TapDeviceDialogForWin().open();
            if (re != null && re.getButtonType() != null && re.getButtonType() == ButtonType.OK) {
                NetTapDeviceViewItem.this.tapButton.setDisable(true);
                NetTapDeviceViewItem.this.newTap = re.getTapName();
                String host = re.getHostNetName();
                TapCreateWorkerDialog worker = new TapCreateWorkerDialog(NetTapDeviceViewItem.this.newTap, host);
                boolean isSucces = worker.create();
                NetTapDeviceViewItem.this.tapButton.setDisable(false);
                if (isSucces) {
                    Event event = new Event(EventType.Modify);
                    event.text = NetTapDeviceViewItem.this.newTap;
                    event.data = null;
                    event.index = -1;
                    NetTapDeviceViewItem.this.sendEvent(event);
                }
            }
        }
    };

    public NetTapDeviceViewItem() {
        if (OSUtil.isWin()) {
            this.tapButton = new ImageButton(ImageKind.BTN_NEW_TAP_NML, ImageKind.BTN_NEW_TAP_HOVER, ImageKind.BTN_NEW_TAP_HOVER);
            this.tapButton.setOnMouseClicked(this.actionHandler);
        }
        HBox box = new HBox();
        box.setAlignment(Pos.CENTER_LEFT);
        box.getChildren().add((Object)this.combo);
        HBox.setHgrow((Node)this.combo, (Priority)Priority.ALWAYS);
        if (this.tapButton != null) {
            box.getChildren().add((Object)this.tapButton.getPane());
            HBox.setHgrow((Node)this.tapButton.getPane(), (Priority)Priority.NEVER);
            HBox.setMargin((Node)this.tapButton.getPane(), (Insets)new Insets(0.0, 0.0, 0.0, 10.0));
        }
        this.baseView.setPrefHeight(28.0);
        this.baseView.setViewItem((Node)box);
    }

    public void setComboEnable(boolean isEnable) {
        this.combo.setDisable(!isEnable);
    }

    public boolean isComboEnabled() {
        return !this.combo.isDisable();
    }
}

