/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.emulator.manager.concurrent;

import java.io.File;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import org.tizen.emulator.manager.resources.FilePathResources;

final class InterprocessSynchronizer {
    static final InterprocessSynchronizer instance = new InterprocessSynchronizer();
    final Path lockPath = Paths.get(FilePathResources.getTizenSDKDataVmsPath() + File.separator + ".em-" + System.getProperty("user.name") + ".serialize.lock", new String[0]);
    FileChannel fc;
    FileLock lock;
    int lockCount = 0;

    private InterprocessSynchronizer() {
    }

    synchronized void getLock() {
        ++this.lockCount;
        if (this.lock != null && this.lock.isValid()) {
            return;
        }
        try {
            this.fc = FileChannel.open(this.lockPath, StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING);
            this.lock = this.fc.lock();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    synchronized void releaseLock() {
        --this.lockCount;
        if (this.lockCount > 0) {
            return;
        }
        assert (this.lock != null);
        try {
            if (this.lock.isValid()) {
                this.lock.release();
                this.lock = null;
            }
            if (this.fc != null) {
                this.fc.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

