/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.emulator.manager.platform.custom;

import java.io.File;
import java.util.List;
import org.tizen.emulator.manager.platform.Platform;
import org.tizen.emulator.manager.platform.PlatformList;
import org.tizen.emulator.manager.platform.custom.CustomPlatform;
import org.tizen.emulator.manager.platform.custom.CustomPlatformImageLoader;
import org.tizen.emulator.manager.platform.custom.CustomPlatformImageValue;

public class CustomPlatformImageWorker {
    public static Platform create(CustomPlatformImageValue value) {
        File parentDir;
        if (value == null) {
            return null;
        }
        CustomPlatform platform = (CustomPlatform)Platform.createCustomInstance(value);
        if (platform == null) {
            return null;
        }
        List<String> pathList = value.getPathList();
        if (!pathList.isEmpty() && (parentDir = new File(pathList.get(0)).getParentFile()) != null) {
            CustomPlatformImageLoader.setLastDirectory(parentDir.getAbsolutePath());
        }
        CustomPlatformImageLoader.saveBaseImageConfiguration();
        return platform;
    }

    public static boolean modify(CustomPlatform platform, CustomPlatformImageValue value) {
        platform.setValue(value);
        return CustomPlatformImageLoader.saveBaseImageConfiguration();
    }

    public static boolean delete(CustomPlatform platform) {
        return CustomPlatformImageWorker.delete(platform, false);
    }

    public static boolean delete(CustomPlatform platform, boolean needDeleteFile) {
        PlatformList.remove(platform);
        boolean result = CustomPlatformImageLoader.saveBaseImageConfiguration();
        if (result && needDeleteFile) {
            for (String path : platform.getImagePathList()) {
                File file = new File(path);
                file.delete();
            }
        }
        return result;
    }
}

