/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.emulator.manager.devices;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import org.tizen.emulator.manager.devices.DeviceTemplate;
import org.tizen.emulator.manager.devices.DeviceTemplateUtil;
import org.tizen.emulator.manager.resources.FilePathResources;

public class CommonDeviceTemplateList {
    private static SortedSet<DeviceTemplate> templateList = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SortedSet<DeviceTemplate> getDeviceTemplateList(boolean isRefresh) {
        Class<CommonDeviceTemplateList> clazz = CommonDeviceTemplateList.class;
        synchronized (CommonDeviceTemplateList.class) {
            if (templateList == null || isRefresh) {
                templateList = CommonDeviceTemplateList.loadTemplates();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return templateList;
        }
    }

    public static List<DeviceTemplate> getCustomDeviceTemplateList() {
        ArrayList<DeviceTemplate> list = new ArrayList<DeviceTemplate>();
        for (DeviceTemplate template : templateList) {
            if (template.getValue().isStandard()) continue;
            list.add(template);
        }
        return list;
    }

    public static List<DeviceTemplate> getStandardDeviceTemplateList() {
        ArrayList<DeviceTemplate> list = new ArrayList<DeviceTemplate>();
        for (DeviceTemplate template : templateList) {
            if (!template.getValue().isStandard()) continue;
            list.add(template);
        }
        return list;
    }

    public static void addTemplate(DeviceTemplate template) {
        if (template != null) {
            templateList.add(template);
        }
    }

    public static void removeTemplate(DeviceTemplate template) {
        if (template != null) {
            templateList.remove(template);
        }
    }

    static synchronized SortedSet<DeviceTemplate> loadTemplates() {
        TreeSet<DeviceTemplate> deviceList = new TreeSet<DeviceTemplate>();
        File commonDir = new File(FilePathResources.getPlatformCommonPath());
        File[] profileList = commonDir.listFiles();
        if (profileList != null && profileList.length > 0) {
            for (File profile : profileList) {
                if (!profile.isDirectory()) continue;
                DeviceTemplateUtil.loadTemplates(profile.getAbsolutePath() + FilePathResources.getPlatformDeviceTemplateSuffix(), deviceList);
            }
        } else {
            DeviceTemplateUtil.loadTemplates(FilePathResources.getToolEmulatorDevicePath(), deviceList);
        }
        DeviceTemplateUtil.loadTemplates(FilePathResources.getTizenSDKDataDeviceCommonPath(), deviceList);
        DeviceTemplateUtil.loadTemplates(FilePathResources.getTizenSDKDataDevicePath(), deviceList);
        return deviceList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        Class<CommonDeviceTemplateList> clazz = CommonDeviceTemplateList.class;
        synchronized (CommonDeviceTemplateList.class) {
            templateList = CommonDeviceTemplateList.loadTemplates();
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }
}

