/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.emulator.manager.ui.controller.vms;

import java.util.List;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.event.EventType;
import javafx.scene.Node;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SeparatorMenuItem;
import javafx.scene.control.TableRow;
import javafx.scene.control.TableView;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.util.Callback;
import org.tizen.emulator.manager.logging.EMLogger;
import org.tizen.emulator.manager.ui.controller.vms.ROW_STATE;
import org.tizen.emulator.manager.ui.controller.vms.TableSelectionListener;
import org.tizen.emulator.manager.ui.item.DetailHandler;
import org.tizen.emulator.manager.ui.item.ModifyHandler;
import org.tizen.emulator.manager.ui.item.VMEventHandler;
import org.tizen.emulator.manager.ui.item.VMItem;

class VMTableRow
extends TableRow<VMItem> {
    private final TableView<VMItem> table;
    private final ContextMenu contextMenu = new ContextMenu();
    private final MenuItem mLaunch = new MenuItem("Launch");
    private final MenuItem mModify = new MenuItem("Edit");
    private final MenuItem mDelete = new MenuItem("Delete");
    private final MenuItem mReset = new MenuItem("Reset");
    private final MenuItem mExport = new MenuItem("Export as");
    private final MenuItem mDetail = new MenuItem("Detail");
    private final EventHandler<MouseEvent> mouseEvent = new EventHandler<MouseEvent>(){

        public void handle(MouseEvent event) {
            VMTableRow.this.mouseEventHandler(event);
        }
    };

    VMTableRow(final TableView<VMItem> table) {
        this.table = table;
        this.setOnMouseClicked(this.mouseEvent);
        this.setOnMouseEntered(this.mouseEvent);
        this.setOnMouseExited(this.mouseEvent);
        ObservableList items = this.contextMenu.getItems();
        items.add((Object)this.mLaunch);
        items.add((Object)this.mModify);
        items.add((Object)this.mDelete);
        items.add((Object)this.mReset);
        items.add((Object)this.mExport);
        items.add((Object)new SeparatorMenuItem());
        items.add((Object)this.mDetail);
        this.mLaunch.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                EMLogger.getLogger().fine("Click launch menu");
                VMEventHandler.launch((VMItem)table.getSelectionModel().getSelectedItems().get(0));
            }
        });
        this.mModify.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                EMLogger.getLogger().fine("Click modify menu");
                ModifyHandler.modify((VMItem)table.getSelectionModel().getSelectedItems().get(0));
            }
        });
        this.mDelete.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                EMLogger.getLogger().fine("Click delete menu");
                VMEventHandler.delete((List<VMItem>)table.getSelectionModel().getSelectedItems());
            }
        });
        this.mReset.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                EMLogger.getLogger().fine("Click reset menu");
                VMEventHandler.reset((ObservableList<VMItem>)table.getSelectionModel().getSelectedItems());
            }
        });
        this.mExport.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                EMLogger.getLogger().fine("Click export menu");
                VMEventHandler.export((VMItem)table.getSelectionModel().getSelectedItems().get(0));
            }
        });
        this.mDetail.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                EMLogger.getLogger().fine("Click detail menu");
                DetailHandler.detail((VMItem)table.getSelectionModel().getSelectedItems().get(0));
            }
        });
    }

    void mouseEventHandler(MouseEvent event) {
        VMItem vmItem = (VMItem)this.getItem();
        if (vmItem == null) {
            return;
        }
        EventType type = event.getEventType();
        if (type == MouseEvent.MOUSE_CLICKED) {
            ObservableList selectedItem = this.table.getSelectionModel().getSelectedItems();
            if (selectedItem == null) {
                return;
            }
            if (event.getButton() == MouseButton.SECONDARY) {
                if (selectedItem.size() == 0) {
                    return;
                }
                boolean disableModify = TableSelectionListener.getDisableModify().get();
                boolean disableDelete = TableSelectionListener.getDisableDelete().get();
                boolean disableReset = TableSelectionListener.getDisableReset().get();
                boolean disableDetail = TableSelectionListener.getDisableDetail().get();
                this.mLaunch.setDisable(disableModify);
                this.mModify.setDisable(disableModify);
                this.mDelete.setDisable(disableDelete);
                this.mReset.setDisable(disableReset);
                if (selectedItem.size() == 1) {
                    this.mExport.setDisable(disableModify || !((VMItem)selectedItem.get(0)).useQCOW2Image());
                } else {
                    this.mExport.setDisable(disableModify);
                }
                this.mDetail.setDisable(disableDetail);
                this.contextMenu.show((Node)this, event.getScreenX(), event.getScreenY());
            }
            return;
        }
        if (this.selectedProperty().get()) {
            return;
        }
        if (type == MouseEvent.MOUSE_ENTERED) {
            vmItem.setRowState(ROW_STATE.OVER);
        } else {
            vmItem.setRowState(ROW_STATE.NORMAL);
        }
    }

    static Callback<TableView<VMItem>, TableRow<VMItem>> extractor() {
        return new Callback<TableView<VMItem>, TableRow<VMItem>>(){

            public TableRow<VMItem> call(TableView<VMItem> table) {
                VMTableRow row = new VMTableRow(table);
                return row;
            }
        };
    }
}

