/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.emulator.manager.ui.tabview;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.geometry.Side;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.layout.Pane;
import javafx.scene.layout.VBox;
import org.tizen.emulator.manager.devices.DeviceTemplateValue;
import org.tizen.emulator.manager.logging.EMLogger;
import org.tizen.emulator.manager.platform.Platform;
import org.tizen.emulator.manager.ui.Main;
import org.tizen.emulator.manager.ui.controller.create.VMDialogData;
import org.tizen.emulator.manager.ui.controller.create.VMDialogPage;
import org.tizen.emulator.manager.ui.item.PlatformDisplayData;
import org.tizen.emulator.manager.ui.item.VMValue;
import org.tizen.emulator.manager.ui.item.ViewItemFactory;
import org.tizen.emulator.manager.ui.tabview.MODE;
import org.tizen.emulator.manager.ui.tabview.PropertyValue;
import org.tizen.emulator.manager.ui.tabview.STATE;
import org.tizen.emulator.manager.ui.tabview.controller.ViewItemController;
import org.tizen.emulator.manager.ui.tabview.event.EventHandler;
import org.tizen.emulator.manager.ui.tabview.event.ItemEvent;
import org.tizen.emulator.manager.ui.template.item.Item;
import org.tizen.emulator.manager.vms.VMProperty;
import org.tizen.emulator.manager.vms.VMPropertyValue;

public class TabViewer
implements VMDialogPage {
    private MODE mode = MODE.CREATE;
    private final TabPane tabPane;
    private final List<ViewItemController> allItems = new ArrayList<ViewItemController>();
    VMPropertyValue vmPropertyValue;
    PropertyValue newValue;
    SimpleBooleanProperty isInvalid;
    private VMDialogData dialogData;
    private final ObjectProperty<Platform> platform = new SimpleObjectProperty<Platform>(null){
        WeakReference<Platform> platformRef;
        {
            this.platformRef = new WeakReference<Object>(null);
        }

        protected void invalidated() {
            Platform oldPlatform = (Platform)this.platformRef.get();
            Platform newPlatform = (Platform)TabViewer.this.platform.get();
            if (oldPlatform != null && oldPlatform.equals(newPlatform)) {
                return;
            }
            this.platformRef = new WeakReference<Platform>(newPlatform);
            TabViewer.this.updateLayout(newPlatform);
        }
    };
    private VMValue modifiedValue = null;
    private boolean modifyInvalid = false;
    private boolean stateInvalid = false;
    private final EventHandler<ItemEvent> modifyHandler = new EventHandler<ItemEvent>(){

        @Override
        public void handleEvent(ItemEvent event) {
            if (event.controller == null || !(event.controller instanceof ViewItemController)) {
                return;
            }
            event.controller.setPropertyValue(TabViewer.this.modifiedValue);
            VMPropertyValue original = (VMPropertyValue)TabViewer.this.newValue.getData();
            VMPropertyValue modified = (VMPropertyValue)TabViewer.this.modifiedValue.getData();
            TabViewer.this.modifyInvalid = original.equals(modified);
            if (!TabViewer.this.stateInvalid && !TabViewer.this.modifyInvalid) {
                TabViewer.this.isInvalid.set(false);
            } else {
                TabViewer.this.isInvalid.set(true);
            }
        }
    };
    private final EventHandler<ItemEvent> stateChangeHandler = new EventHandler<ItemEvent>(){

        @Override
        public void handleEvent(ItemEvent event) {
            if (event.newState == STATE.ERROR || event.newState == STATE.ESSENTIAL) {
                TabViewer.this.stateInvalid = true;
            } else {
                TabViewer.this.stateInvalid = false;
                for (ViewItemController item : TabViewer.this.allItems) {
                    if (item.getState() != STATE.ERROR && item.getState() != STATE.ESSENTIAL) continue;
                    TabViewer.this.stateInvalid = true;
                    break;
                }
            }
            if (!TabViewer.this.stateInvalid && !TabViewer.this.modifyInvalid) {
                TabViewer.this.isInvalid.set(false);
            } else {
                TabViewer.this.isInvalid.set(true);
            }
        }
    };

    public Platform getPlatform() {
        return (Platform)this.platform.get();
    }

    public void setPlatform(Platform platform) {
        this.platform.setValue((Object)platform);
    }

    public TabViewer() {
        this.tabPane = new TabPane();
        this.tabPane.setSide(Side.LEFT);
        this.tabPane.setRotateGraphic(true);
        this.tabPane.setTabClosingPolicy(TabPane.TabClosingPolicy.UNAVAILABLE);
        this.tabPane.getStylesheets().add((Object)Main.class.getResource("/view/tab_view.css").toExternalForm());
        this.tabPane.getStylesheets().addAll(Main.getBaseCssUrl());
    }

    @Override
    public Node getNode() {
        return this.tabPane;
    }

    private void updateLayout(Platform platform) {
        VMProperty prop = platform.getDefaultProperty();
        if (!this.allItems.isEmpty()) {
            for (ViewItemController item : this.allItems) {
                item.dispose();
            }
            this.allItems.clear();
        }
        this.tabPane.getTabs().clear();
        ViewItemController.removeAllStateChangeEventHandler();
        if (this.mode == MODE.CREATE) {
            this.tabPane.setStyle("-fx-border-width: 1 0 1 0;");
            this.newValue = new VMValue(VMPropertyValue.createValueForNewVM(platform, prop));
            DeviceTemplateValue deviceTemplateValue = this.dialogData.getDeviceTemplate().getValue();
            this.newValue.setStringValue("deviceTemplate", deviceTemplateValue.getName());
            this.newValue.setObjectValue("deviceTemplate", this.dialogData.getDeviceTemplate());
        } else {
            this.tabPane.setStyle("-fx-border-width: 0 0 0 0;");
            this.newValue = new VMValue(this.vmPropertyValue);
            this.modifiedValue = new VMValue(new VMPropertyValue(this.vmPropertyValue));
        }
        PlatformDisplayData platformData = PlatformDisplayData.getData(platform);
        ViewItemFactory factory = platformData.getViewItemFactory();
        if (factory != null) {
            factory.setMode(this.mode);
            List<Item> tabItems = factory.getTabList(platformData.getPropertyUI());
            this.makeTabViewer(this.newValue, factory, tabItems);
        }
    }

    private void makeTabViewer(PropertyValue value, ViewItemFactory factory, List<Item> tabItems) {
        for (Item item : tabItems) {
            Tab tab = new Tab();
            Label label = new Label(item.getTitle());
            label.setMinWidth(140.0);
            label.getStyleClass().add((Object)"left-tab-label");
            label.setRotate(90.0);
            tab.setGraphic((Node)label);
            List<ViewItemController> items = null;
            factory.setMode(this.mode);
            items = factory.getViewItemList(item, null);
            this.allItems.addAll(items);
            VBox vBox = new VBox();
            vBox.setPadding(new Insets(20.0, 0.0, 20.0, 30.0));
            vBox.setAlignment(Pos.TOP_LEFT);
            vBox.setPrefSize(473.0, 529.0);
            for (ViewItemController i : items) {
                Pane pane = i.getViewItem().getContent();
                vBox.getChildren().add((Object)pane);
                VBox.setMargin((Node)pane, (Insets)new Insets(5.0, 0.0, 5.0, 0.0));
                ViewItemController.addStateChangeEventHandler(i.getName(), this.stateChangeHandler);
                if (this.mode == MODE.MODIFY) {
                    this.modifyInvalid = true;
                    i.addModifiedListener(this.modifyHandler);
                }
                i.setMode(this.mode);
                i.setIntializeValue(value);
            }
            ScrollPane scroll = new ScrollPane();
            scroll.setPrefSize(vBox.getPrefWidth(), vBox.getPrefHeight());
            scroll.setContent((Node)vBox);
            scroll.setHbarPolicy(ScrollPane.ScrollBarPolicy.AS_NEEDED);
            scroll.setVbarPolicy(ScrollPane.ScrollBarPolicy.AS_NEEDED);
            scroll.setFitToWidth(true);
            scroll.setFitToHeight(true);
            tab.setContent((Node)scroll);
            this.tabPane.getTabs().add((Object)tab);
        }
    }

    @Override
    public void onPageShow(VMDialogData vmDialogData, SimpleBooleanProperty isInvalid) {
        this.isInvalid = isInvalid;
        this.dialogData = vmDialogData;
        this.mode = vmDialogData.getMode();
        if (this.mode == MODE.MODIFY) {
            EMLogger.getLogger().fine("Open Modify tab view");
            this.vmPropertyValue = vmDialogData.getVmValue();
            isInvalid.set(true);
        } else {
            EMLogger.getLogger().fine("Open Create tab view");
        }
        Platform platform = vmDialogData.getPlatform();
        this.setPlatform(platform);
    }

    @Override
    public void setData(VMDialogData vmDialogData) {
        for (ViewItemController item : this.allItems) {
            item.setPropertyValue(this.newValue);
        }
        vmDialogData.setVmValue((VMPropertyValue)this.newValue.getData());
    }

    @Override
    public String getTitle() {
        return "Properties";
    }

    @Override
    public String getDescription() {
        return "Define the Emulator properties";
    }

    @Override
    public boolean onPageHide(VMDialogData vmDialogData) {
        return true;
    }
}

