/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.emulator.manager.ui.tabview.controller;

import org.tizen.emulator.manager.ui.tabview.PropertyValue;
import org.tizen.emulator.manager.ui.tabview.controller.ViewItemController;
import org.tizen.emulator.manager.ui.tabview.event.Event;
import org.tizen.emulator.manager.ui.tabview.event.EventHandler;
import org.tizen.emulator.manager.ui.tabview.event.EventType;
import org.tizen.emulator.manager.ui.tabview.event.ItemEvent;
import org.tizen.emulator.manager.ui.tabview.item.FileViewItem;
import org.tizen.emulator.manager.ui.tabview.item.ViewItem;
import org.tizen.emulator.manager.ui.template.item.Item;
import org.tizen.emulator.manager.ui.template.item.Option;

public class FileViewController
extends ViewItemController {
    private static String DIR = "directory";
    private static String FILE = "file";
    protected FileViewItem fileItem = null;
    protected FileViewItem.Type fileType = FileViewItem.Type.FILE;

    public FileViewController(Item item) {
        this(item, null);
    }

    public FileViewController(Item item, ViewItemController parent) {
        super(item, parent);
        for (Option option : item.getOptions()) {
            if (!option.getName().equals("dialogType")) continue;
            String value = option.getValue();
            if (value.equals(DIR)) {
                this.fileType = FileViewItem.Type.DIR;
                continue;
            }
            if (!value.equals(FILE)) continue;
            this.fileType = FileViewItem.Type.FILE;
        }
    }

    @Override
    public void makeViewItem() {
        this.setViewItem(new FileViewItem());
    }

    @Override
    public ViewItem getViewItem() {
        return this.fileItem;
    }

    @Override
    public void setViewItem(ViewItem item) {
        this.fileItem = item instanceof FileViewItem ? (FileViewItem)item : new FileViewItem();
        this.fileItem.setType(this.fileType);
        this.fileItem.setTitle(this.getTitle());
        this.fileItem.addEventHandler(EventType.Selection, new EventHandler<Event>(){

            @Override
            public void handleEvent(Event event) {
                FileViewController.this.onChangedValue(event);
            }
        });
    }

    @Override
    protected void onChangedValue(Event event) {
        ItemEvent iEvent = new ItemEvent(this.getName(), this);
        iEvent.oldValue = "";
        iEvent.newValue = event.text;
        ViewItemController.sendChangeEvent(iEvent);
    }

    @Override
    public void setIntializeValue(PropertyValue value) {
        String path = value.getStringValue(this.getName());
        this.fileItem.setFile(path);
    }

    @Override
    public void setPropertyValue(PropertyValue value) {
        value.setStringValue(this.getName(), this.fileItem.getFilePath());
    }

    @Override
    public void checkValid() {
    }
}

