/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.emulator.manager.ui.platform.controller;

import org.tizen.emulator.manager.ui.platform.item.PlatformDescViewItem;
import org.tizen.emulator.manager.ui.tabview.PropertyValue;
import org.tizen.emulator.manager.ui.tabview.STATE;
import org.tizen.emulator.manager.ui.tabview.controller.ViewItemController;
import org.tizen.emulator.manager.ui.tabview.event.Event;
import org.tizen.emulator.manager.ui.tabview.event.EventHandler;
import org.tizen.emulator.manager.ui.tabview.event.EventType;
import org.tizen.emulator.manager.ui.tabview.event.ItemEvent;
import org.tizen.emulator.manager.ui.tabview.item.ViewItem;
import org.tizen.emulator.manager.ui.template.item.Item;

public class PlatformDescViewController
extends ViewItemController {
    private PlatformDescViewItem viewItem;
    private final int DESC_MAX_LEN = 200;

    public PlatformDescViewController(Item item) {
        super(item);
    }

    @Override
    public void makeViewItem() {
        this.setViewItem(new PlatformDescViewItem());
    }

    @Override
    public ViewItem getViewItem() {
        return this.viewItem;
    }

    @Override
    public void setViewItem(ViewItem item) {
        if (item instanceof PlatformDescViewItem) {
            this.viewItem = (PlatformDescViewItem)item;
        }
        if (this.viewItem == null) {
            return;
        }
        this.viewItem.setMaxLen(200);
        this.viewItem.setTitle(this.getTitle());
        this.addListener();
    }

    private void addListener() {
        this.viewItem.addEventHandler(EventType.Modify, new EventHandler<Event>(){

            @Override
            public void handleEvent(Event event) {
                PlatformDescViewController.this.checkValid();
                PlatformDescViewController.this.onChangedValue(event);
            }
        });
    }

    @Override
    protected void onChangedValue(Event event) {
        ItemEvent iEvent = new ItemEvent(this.getName(), this);
        ViewItemController.sendChangeEvent(iEvent);
    }

    @Override
    public void setIntializeValue(PropertyValue value) {
        this.viewItem.setText(value.getStringValue(this.getName()));
    }

    @Override
    public void setPropertyValue(PropertyValue value) {
        value.setStringValue(this.getName(), this.viewItem.getText());
    }

    @Override
    public void checkValid() {
        STATE newState = STATE.OK;
        String errorMsg = "";
        int length = this.viewItem.getText().length();
        if (length > 200) {
            newState = STATE.ERROR;
            errorMsg = "Description is too long.\nMax character count is 200.";
        }
        this.setItemState(newState, errorMsg);
    }
}

