/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.emulator.manager.ui.tabview.item;

import java.lang.ref.WeakReference;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.Label;
import javafx.scene.control.Tooltip;
import javafx.scene.image.ImageView;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Text;
import org.tizen.emulator.manager.ui.resources.ImageKind;
import org.tizen.emulator.manager.ui.resources.Images;
import org.tizen.emulator.manager.ui.tabview.STATE;

public class BaseViewItem {
    protected final double STATE_LABEL_SIZE = 16.0;
    protected final double STATE_LABEL_LEFT_GAP = 4.0;
    protected final double STATE_LABEL_RIGHT_GAP = 5.0;
    protected final double ITEM_TOP_GAP = 5.0;
    protected final double ITEM_RIGHT_GAP = 10.0;
    protected final double ITEM_BOTTOM_GAP = 5.0;
    protected final double ITEM_LEFT_GAP = 0.0;
    private final DoubleProperty titleMinWidthProperty = new SimpleDoubleProperty((Object)this, "titleMinWidthProperty");
    private final DoubleProperty prefWidthProperty = new SimpleDoubleProperty((Object)this, "prefWidthProperty");
    private final DoubleProperty prefHeightProperty = new SimpleDoubleProperty((Object)this, "prefHeightProperty");
    protected GridPane pane;
    protected VBox titleBox;
    protected Label titleLabel;
    protected Label stateLabel;
    private final StringProperty title = new SimpleStringProperty(this, "Title"){

        protected void invalidated() {
            BaseViewItem.this.updateLayout();
        }
    };
    private final ObjectProperty<Node> item = new SimpleObjectProperty<Node>(null){
        WeakReference<Node> contentRef;
        {
            this.contentRef = new WeakReference<Object>(null);
        }

        protected void invalidated() {
            Node oldContent = (Node)this.contentRef.get();
            if (oldContent != null) {
                BaseViewItem.this.pane.getChildren().remove((Object)oldContent);
            }
            Node newContent = BaseViewItem.this.getViewItem();
            this.contentRef = new WeakReference<Node>(newContent);
            BaseViewItem.this.updateLayout();
        }
    };
    private Priority hGrowPriority = Priority.ALWAYS;
    private final ObjectProperty<Node> content = new SimpleObjectProperty<Node>(null){
        WeakReference<Node> contentRef;
        {
            this.contentRef = new WeakReference<Object>(null);
        }

        protected void invalidated() {
            Node oldContent = (Node)this.contentRef.get();
            if (oldContent != null) {
                BaseViewItem.this.pane.getChildren().remove((Object)oldContent);
            }
            Node newContent = BaseViewItem.this.getContent();
            this.contentRef = new WeakReference<Node>(newContent);
            BaseViewItem.this.updateLayout();
        }
    };
    private final ObjectProperty<STATE> state = new SimpleObjectProperty<STATE>(STATE.OK){
        WeakReference<STATE> stateRef;
        {
            this.stateRef = new WeakReference<STATE>(STATE.OK);
        }

        protected void invalidated() {
            STATE newState;
            STATE oldState = (STATE)((Object)this.stateRef.get());
            if (oldState == (newState = BaseViewItem.this.getState())) {
                return;
            }
            this.stateRef = new WeakReference<STATE>(newState);
            BaseViewItem.this.updateState();
        }
    };
    private final StringProperty stateToolTip = new SimpleStringProperty(this, ""){

        protected void invalidated() {
            BaseViewItem.this.updateState();
        }
    };
    private final Text essential = new Text("*");
    private final ImageView error = new ImageView(Images.get(ImageKind.ICON_STATE_ERROR));
    private final ImageView warning = new ImageView(Images.get(ImageKind.ICON_STATE_WARNING));
    private final Tooltip tooltip = new Tooltip();

    public BaseViewItem() {
        this.pane = new GridPane();
        this.titleBox = new VBox();
        this.titleLabel = new Label();
        this.titleLabel.getStyleClass().add((Object)"titleLabel");
        this.titleBox.getChildren().add((Object)this.titleLabel);
        this.pane.add((Node)this.titleBox, 0, 0);
        this.stateLabel = new Label();
        this.pane.add((Node)this.stateLabel, 2, 0);
        this.setTitleMinWidth(120.0);
        this.setPrefHeight(24.0);
        this.setPrefWidth(433.0);
        GridPane.setMargin((Node)this.stateLabel, (Insets)new Insets(5.0, 4.0, 5.0, 4.0));
        this.essential.setFill(Paint.valueOf((String)Color.rgb((int)0, (int)138, (int)238).toString()));
    }

    public Pane getBasePane() {
        return this.pane;
    }

    public final void setTitleMinWidth(double value) {
        this.titleMinWidthProperty.set(value);
    }

    public final void setPrefWidth(double value) {
        this.prefWidthProperty.set(value);
    }

    public final void setPrefHeight(double value) {
        this.prefHeightProperty.set(value);
    }

    public final double getTitleMinWidth() {
        return this.titleMinWidthProperty.get();
    }

    public final double getPrefWidth() {
        return this.prefWidthProperty.get();
    }

    public final double getPrefHeight() {
        return this.prefHeightProperty.get();
    }

    public DoubleProperty getTitleMinWidthProperty() {
        return this.titleMinWidthProperty;
    }

    public DoubleProperty getMinWidthProperty() {
        return this.prefWidthProperty;
    }

    public DoubleProperty getPrefHeightProperty() {
        return this.prefHeightProperty;
    }

    public final void setTitle(String text) {
        this.title.set((Object)text);
    }

    public final String getTitle() {
        return (String)this.title.get();
    }

    public void removeTitleStyle() {
        this.titleLabel.getStyleClass().remove((Object)"titleLabel");
    }

    public final void setViewItem(Node item) {
        this.item.set((Object)item);
    }

    public final Node getViewItem() {
        return (Node)this.item.get();
    }

    public Priority gethGrowPriority() {
        return this.hGrowPriority;
    }

    public void sethGrowPriority(Priority hGrowPriority) {
        this.hGrowPriority = hGrowPriority;
        if (this.getViewItem() != null) {
            GridPane.setHgrow((Node)this.getViewItem(), (Priority)hGrowPriority);
        }
    }

    public Node getContent() {
        return (Node)this.content.get();
    }

    public void setContent(Node content) {
        this.content.setValue((Object)content);
    }

    public void removeStateLabel() {
        this.pane.getChildren().remove((Object)this.stateLabel);
    }

    public STATE getState() {
        return (STATE)((Object)this.state.get());
    }

    public void setState(STATE state) {
        this.state.set((Object)state);
    }

    public final void setStateToolTip(String text) {
        this.stateToolTip.set((Object)text);
    }

    public final String getStateToolTip() {
        return (String)this.stateToolTip.get();
    }

    protected void updateLayout() {
        Node content = this.getContent();
        if (content != null) {
            if (!this.pane.getChildren().contains((Object)content)) {
                this.pane.add(content, 0, 0);
            }
            content.setVisible(true);
            GridPane.setMargin((Node)content, (Insets)new Insets(0.0, 0.0, 0.0, 0.0));
            this.titleLabel.setVisible(false);
        } else {
            String title = this.getTitle();
            boolean visible = title != null && !title.isEmpty();
            this.titleLabel.setText(visible ? title : "");
            this.titleLabel.setVisible(visible);
            this.titleLabel.setManaged(visible);
            this.titleBox.setVisible(visible);
            if (visible) {
                this.titleBox.setMinWidth(this.getTitleMinWidth());
                GridPane.setMargin((Node)this.titleBox, (Insets)new Insets(5.0, 10.0, 5.0, 0.0));
            }
            this.stateLabel.setMinWidth(16.0);
            this.stateLabel.setMaxWidth(16.0);
            if (this.getViewItem() != null && !this.pane.getChildren().contains((Object)this.getViewItem())) {
                this.pane.add(this.getViewItem(), 1, 0);
                GridPane.setHgrow((Node)this.getViewItem(), (Priority)this.hGrowPriority);
            }
        }
        this.pane.setPrefWidth(this.getPrefWidth());
        this.pane.setPrefHeight(this.getPrefHeight());
        this.layout();
    }

    protected void updateState() {
        STATE s = this.getState();
        switch (s) {
            case OK: {
                this.stateLabel.setGraphic(null);
                this.stateLabel.setTooltip(null);
                if (!this.titleLabel.visibleProperty().get()) break;
                this.titleLabel.setGraphic(null);
                break;
            }
            case WARNING: {
                this.stateLabel.setGraphic((Node)this.warning);
                this.tooltip.setText(this.getStateToolTip());
                this.stateLabel.setTooltip(this.tooltip);
                if (!this.titleLabel.visibleProperty().get()) break;
                this.titleLabel.setGraphic(null);
                break;
            }
            case ERROR: {
                this.stateLabel.setGraphic((Node)this.error);
                this.tooltip.setText(this.getStateToolTip());
                this.stateLabel.setTooltip(this.tooltip);
                if (!this.titleLabel.visibleProperty().get()) break;
                this.titleLabel.setGraphic(null);
                break;
            }
            case ESSENTIAL: {
                this.stateLabel.setGraphic(null);
                this.stateLabel.setTooltip(null);
                if (!this.titleLabel.visibleProperty().get()) break;
                this.titleLabel.setGraphic((Node)this.essential);
                this.titleLabel.setContentDisplay(ContentDisplay.RIGHT);
            }
        }
    }

    public void layout() {
        this.pane.autosize();
        this.pane.layout();
    }
}

