/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.emulator.manager.ui;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.lang.reflect.Field;
import java.net.URL;
import java.nio.channels.FileLock;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import javafx.application.Application;
import javafx.fxml.FXMLLoader;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.image.Image;
import javafx.scene.layout.Pane;
import javafx.stage.Stage;
import javafx.stage.Window;
import javax.swing.JOptionPane;
import javax.xml.bind.JAXBException;
import org.tizen.emulator.manager.EmulatorManager;
import org.tizen.emulator.manager.EmulatorManagerMode;
import org.tizen.emulator.manager.concurrent.overseer.CheckGPU;
import org.tizen.emulator.manager.concurrent.overseer.CheckSDCard;
import org.tizen.emulator.manager.concurrent.overseer.CheckVT;
import org.tizen.emulator.manager.concurrent.overseer.CheckWebcam;
import org.tizen.emulator.manager.concurrent.overseer.Overseer;
import org.tizen.emulator.manager.logging.EMLogger;
import org.tizen.emulator.manager.platform.PlatformList;
import org.tizen.emulator.manager.resources.FilePathResources;
import org.tizen.emulator.manager.resources.StringResources;
import org.tizen.emulator.manager.tool.About;
import org.tizen.emulator.manager.tool.OSUtil;
import org.tizen.emulator.manager.tool.SettingInfoFile;
import org.tizen.emulator.manager.ui.dialog.PlatformInstallDialog;
import org.tizen.emulator.manager.ui.utils.MacUtil;
import org.tizen.emulator.manager.vms.ManagedVMKeeper;

public class Main
extends Application {
    private static final String ICON_FILE_NAME = "/res/em-256.png";
    private static final URL BASE_CSS_URL = Main.class.getResource("/view/base.css");
    private static final int MIN_WIDTH = 450;
    private static final int MIN_HEIGHT = 450;
    private static final int PREF_WIDTH = 654;
    private static final int PREF_HEIGHT = 610;
    private static Stage primaryStage;
    private static Window mainWindow;
    private static Pane root;

    private static void initializeLogger() {
        File logFile = new File(FilePathResources.getEmulatorManagerLogPath());
        EMLogger.makeBackupLog(Paths.get(logFile.getAbsolutePath(), new String[0]));
        EMLogger.getInstance().initialize();
        EMLogger.getInstance().setFileLogger(logFile);
        if (EmulatorManagerMode.isDebugMode()) {
            EMLogger.getInstance().setLevel(Level.ALL);
        } else {
            EMLogger.getInstance().setLevel(Level.ALL);
        }
        EMLogger.getLogger().log(Level.INFO, "Start Emulator Manager!!");
    }

    static void parseArgs(String[] args) {
        boolean isArgsError = false;
        if (args.length > 0) {
            for (int i = 0; i < args.length; ++i) {
                if (args[i].equals("--experimental")) {
                    EmulatorManagerMode.setInhouseMode(true);
                    continue;
                }
                if (args[i].equals("--debug")) {
                    EmulatorManagerMode.setDebugMode(true);
                    continue;
                }
                isArgsError = true;
            }
        }
        if (isArgsError) {
            System.exit(1);
        }
    }

    static void obtainLockFile() {
        RandomAccessFile randomAccessFile = null;
        String errorMessage = "";
        try {
            randomAccessFile = new RandomAccessFile(new File(FilePathResources.getTizenSDKDataVmsPath() + File.separator + ".em-" + System.getProperty("user.name")) + ".lock", "rw");
        }
        catch (FileNotFoundException e) {
            errorMessage = "The Emulator Manager cannot be launched" + StringResources.NEW_LINE + e.getMessage();
        }
        if (randomAccessFile != null && errorMessage.isEmpty()) {
            try {
                FileLock lock = randomAccessFile.getChannel().tryLock();
                if (lock == null) {
                    errorMessage = "The Emulator Manager cannot be launched" + StringResources.NEW_LINE + "because it is already in use.";
                }
            }
            catch (IOException e) {
                errorMessage = "The Emulator Manager cannot be launched" + StringResources.NEW_LINE + e.getMessage();
            }
        }
        if (!errorMessage.isEmpty()) {
            JOptionPane.showMessageDialog(null, errorMessage, "Emulator Manager", 2);
            System.exit(0);
        }
    }

    public static void main(String[] args) {
        try {
            if (OSUtil.isWin()) {
                OSUtil.setProcessAppUserModelID("EmulatorManager");
            }
            Main.parseArgs(args);
            try {
                FilePathResources.initialize();
            }
            catch (IOException | IllegalStateException e1) {
                e1.printStackTrace();
            }
            Main.obtainLockFile();
            Main.initializeLogger();
            Overseer checkers = Overseer.newOverseer("Checkers", CheckVT.class, CheckGPU.class, CheckSDCard.class, CheckWebcam.class);
            try {
                checkers.startWork();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            About.getInstance().printSystemInformation();
            if (!SettingInfoFile.setMACaddr()) {
                System.exit(1);
            }
            if (OSUtil.isMac()) {
                try {
                    Class<?> macFontFinderClass = Class.forName("com.sun.t2k.MacFontFinder");
                    Field psNameToPathMap = macFontFinderClass.getDeclaredField("psNameToPathMap");
                    psNameToPathMap.setAccessible(true);
                    psNameToPathMap.set(null, new HashMap());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            Main.launch((String[])args);
        }
        catch (Throwable e) {
            e.printStackTrace();
            EMLogger.getLogger().warning("Throw exception: " + e.getMessage());
            EMLogger.printStackTrace(e);
            JOptionPane.showMessageDialog(null, "Unexpected exception occured." + StringResources.NEW_LINE + StringResources.NEW_LINE + "Exception: " + StringResources.NEW_LINE + e.getMessage(), "Emulator Manager", 2);
            System.exit(1);
        }
    }

    public void start(Stage stage) throws Exception {
        primaryStage = stage;
        root = (Pane)FXMLLoader.load((URL)((Object)((Object)this)).getClass().getResource("/view/VMTableView.fxml"));
        root.getStylesheets().add((Object)((Object)((Object)this)).getClass().getResource("/view/table_view.css").toExternalForm());
        root.prefHeight(610.0);
        root.prefWidth(654.0);
        Scene scene = new Scene((Parent)root);
        scene.getStylesheets().addAll(Main.getBaseCssUrl());
        stage.setTitle("Emulator Manager");
        InputStream is = Main.class.getResourceAsStream(ICON_FILE_NAME);
        if (is != null) {
            if (OSUtil.isMac()) {
                try {
                    MacUtil.setDockIcon(is);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    EMLogger.getLogger().warning("Throw exception: " + e.getMessage());
                }
            }
            stage.getIcons().add((Object)new Image(is));
            is.close();
        }
        stage.setScene(scene);
        stage.setMinHeight(450.0);
        stage.setMinWidth(450.0);
        mainWindow = scene.getWindow();
        stage.show();
        try {
            EmulatorManager.initialize(new ManagedVMKeeper());
        }
        catch (JAXBException e) {
            EMLogger.printStackTrace(e);
        }
        if (PlatformList.getList().size() == 0) {
            PlatformInstallDialog.processPlatformInstall(mainWindow);
        }
    }

    public static Stage getPrimaryStage() {
        return primaryStage;
    }

    public static Window getMainWindow() {
        return mainWindow;
    }

    public static List<String> getBaseCssUrl() {
        ArrayList<String> list = new ArrayList<String>();
        list.add(BASE_CSS_URL.toExternalForm());
        return list;
    }
}

