/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.emulator.manager.ui.tabview.controller;

import org.tizen.emulator.manager.devices.DeviceTemplate;
import org.tizen.emulator.manager.devices.DeviceTemplateValue;
import org.tizen.emulator.manager.ui.tabview.PropertyValue;
import org.tizen.emulator.manager.ui.tabview.controller.FileViewController;
import org.tizen.emulator.manager.ui.tabview.controller.ViewItemController;
import org.tizen.emulator.manager.ui.tabview.event.EventHandler;
import org.tizen.emulator.manager.ui.tabview.event.ItemEvent;
import org.tizen.emulator.manager.ui.template.item.Item;

public class DeviceFileViewController
extends FileViewController {
    private final EventHandler<ItemEvent> handler = new EventHandler<ItemEvent>(){

        @Override
        public void handleEvent(ItemEvent event) {
            if (DeviceFileViewController.this.parent == null) {
                return;
            }
            if (event.oldValue.equals(event.newValue)) {
                return;
            }
            DeviceTemplate template = null;
            if (event.data instanceof DeviceTemplate) {
                template = (DeviceTemplate)event.data;
            }
            if (template == null) {
                return;
            }
            DeviceTemplateValue value = template.getValue();
            String path = value.getSubDeviceValue(DeviceFileViewController.this.parent.getName(), DeviceFileViewController.this.getName());
            DeviceFileViewController.this.fileItem.setFile(path);
        }
    };

    public DeviceFileViewController(Item item, ViewItemController parent) {
        super(item, parent);
        ViewItemController.addChangeEventHandler("deviceTemplate", this.handler);
    }

    @Override
    public void setIntializeValue(PropertyValue value) {
        if (this.parent == null) {
            return;
        }
        String path = value.getSubItemStringValue(this.parent.getName(), this.getName());
        this.fileItem.setFile(path);
    }

    @Override
    public void setPropertyValue(PropertyValue value) {
        if (this.parent == null) {
            return;
        }
        value.setSubItemStringValue(this.parent.getName(), this.getName(), this.fileItem.getFilePath());
    }
}

