/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.emulator.manager.ui.controller.vms;

import java.util.ArrayList;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.collections.ListChangeListener;
import javafx.scene.control.TableView;
import org.tizen.emulator.manager.ui.controller.vms.ROW_STATE;
import org.tizen.emulator.manager.ui.item.VMItem;

class TableSelectionListener
implements ListChangeListener<Integer> {
    private final TableView<VMItem> table;
    private static SimpleBooleanProperty disableModify = new SimpleBooleanProperty(true);
    private static SimpleBooleanProperty disableDelete = new SimpleBooleanProperty(true);
    private static SimpleBooleanProperty disableDetail = new SimpleBooleanProperty(true);
    private static SimpleBooleanProperty disableReset = new SimpleBooleanProperty(true);

    public TableSelectionListener(TableView<VMItem> vmTable) {
        this.table = vmTable;
    }

    static SimpleBooleanProperty getDisableModify() {
        return disableModify;
    }

    static SimpleBooleanProperty getDisableDelete() {
        return disableDelete;
    }

    static SimpleBooleanProperty getDisableDetail() {
        return disableDetail;
    }

    static SimpleBooleanProperty getDisableReset() {
        return disableReset;
    }

    public void onChanged(ListChangeListener.Change<? extends Integer> change) {
        for (VMItem item : this.table.getItems()) {
            if (item.getRowState().get() != ROW_STATE.SELECTED) continue;
            item.setRowState(ROW_STATE.NORMAL);
            item.setChecked(false);
        }
        ArrayList<Object> selectedItems = new ArrayList<Object>();
        for (int i = 0; i < this.table.getItems().size(); ++i) {
            if (!this.table.getSelectionModel().isSelected(i)) continue;
            selectedItems.add(this.table.getItems().get(i));
        }
        for (VMItem vMItem : selectedItems) {
            vMItem.setRowState(ROW_STATE.SELECTED);
            vMItem.setChecked(true);
        }
        int count = selectedItems.size();
        if (count == 0) {
            disableModify.set(true);
            disableDelete.set(true);
            disableDetail.set(true);
            disableReset.set(true);
        } else if (count == 1) {
            VMItem vMItem = (VMItem)selectedItems.get(0);
            if (vMItem.isRunning()) {
                disableDetail.set(false);
                disableModify.set(true);
                disableDelete.set(true);
                disableReset.set(true);
            } else if (vMItem.isNotAvailable()) {
                disableDelete.set(false);
                disableModify.set(true);
                disableReset.set(true);
                disableDetail.set(true);
            } else {
                disableModify.set(false);
                disableDelete.set(false);
                disableReset.set(false);
                disableDetail.set(false);
            }
        } else {
            boolean bl;
            boolean bl2 = false;
            boolean isNotAvailable = false;
            for (VMItem vMItem : selectedItems) {
                if (vMItem.isRunning()) {
                    bl = true;
                }
                if (!vMItem.isNotAvailable()) continue;
                isNotAvailable = true;
            }
            if (bl) {
                disableDetail.set(false);
                disableModify.set(true);
                disableDelete.set(true);
                disableReset.set(true);
            } else if (isNotAvailable) {
                disableDelete.set(false);
                disableModify.set(true);
                disableReset.set(true);
                disableDetail.set(true);
            } else {
                disableDelete.set(false);
                disableReset.set(false);
                disableModify.set(true);
                disableDetail.set(true);
            }
        }
    }
}

