/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.emulator.manager.plugin;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import org.tizen.emulator.manager.logging.EMLogger;

public class EMPluginLoader
extends URLClassLoader {
    private EMPluginLoader(URL url) throws MalformedURLException {
        super(new URL[]{url});
    }

    private EMPluginLoader(URL url, ClassLoader parent) throws MalformedURLException {
        super(new URL[]{url}, parent);
    }

    public static ClassLoader makeLoader(File plugin, ClassLoader parent) {
        URL url = null;
        try {
            url = plugin.toURI().toURL();
            if (url == null) {
                throw new MalformedURLException();
            }
            if (parent == null) {
                return new EMPluginLoader(url);
            }
            return new EMPluginLoader(url, parent);
        }
        catch (MalformedURLException e) {
            EMLogger.getLogger().warning("Failed to load url from jar file: " + e.getMessage());
            return null;
        }
    }

    public static Attributes makeAttributes(File pluginJar) {
        JarFile jarFile = null;
        Attributes attr = null;
        try {
            jarFile = new JarFile(pluginJar.getAbsolutePath());
        }
        catch (IOException e) {
            EMLogger.log("Failed to load plugin jar file: " + e.getMessage());
        }
        try {
            if (jarFile != null && jarFile.getManifest() != null) {
                attr = jarFile.getManifest().getMainAttributes();
            }
        }
        catch (IOException e) {
            EMLogger.log("Failed to load Manifest file: " + e.getMessage());
            return null;
        }
        if (jarFile != null) {
            try {
                jarFile.close();
            }
            catch (IOException e) {
                EMLogger.getLogger().info(e.getMessage());
            }
        }
        return attr;
    }

    @Override
    public URL getResource(String name) {
        URL url = this.findResource(name);
        if (url != null) {
            return url;
        }
        return super.getResource(name);
    }
}

