/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.emulator.manager.vms.monitor;

import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.tizen.emulator.manager.logging.EMLogger;
import org.tizen.emulator.manager.platform.Preparer;
import org.tizen.emulator.manager.resources.FilePathResources;
import org.tizen.emulator.manager.tool.OSUtil;
import org.tizen.emulator.manager.vms.monitor.FileAlterationMonitorFileWatcher;
import org.tizen.emulator.manager.vms.monitor.FileWatchEventListener;
import org.tizen.emulator.manager.vms.monitor.MonitoringThread;
import org.tizen.emulator.manager.vms.monitor.WatchServiceFileWatcher;

public abstract class FileWatcher
implements Runnable {
    static FileWatcher instance;
    private final List<FileWatchEventListener> eventListeners;
    protected final List<Path> subdirs;
    private final Path watchPath;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void initialize() throws IOException {
        assert (instance == null);
        instance = OSUtil.isLinux() ? new WatchServiceFileWatcher() : new FileAlterationMonitorFileWatcher();
        instance.startMoinitorThread();
        Path path = FileWatcher.instance.watchPath;
        synchronized (path) {
            FileWatcher.instance.watchPath.notifyAll();
        }
    }

    protected FileWatcher() throws IOException {
        String vmsPath = FilePathResources.getTizenSDKDataVmsPath();
        this.watchPath = Paths.get(vmsPath, new String[0]);
        assert (Files.exists(this.watchPath, new LinkOption[0]));
        this.subdirs = new ArrayList<Path>();
        this.eventListeners = new ArrayList<FileWatchEventListener>();
    }

    protected void startMoinitorThread() {
        MonitoringThread.newMonitoringThread(this, "FileWatcher").start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static final void addListener(FileWatchEventListener listener) throws IOException {
        List<FileWatchEventListener> list = FileWatcher.instance.eventListeners;
        synchronized (list) {
            listener.preexistingDirectoryFound(FileWatcher.instance.subdirs.toArray(new Path[FileWatcher.instance.subdirs.size()]));
            FileWatcher.instance.eventListeners.add(listener);
        }
    }

    protected abstract void registerWatchRoot(Path var1) throws IOException;

    protected abstract void monitoring() throws IOException, InterruptedException;

    protected abstract void registerDirectoryInternal(Path var1) throws IOException;

    private void registerDirectory(Path path) {
        try {
            this.registerDirectoryInternal(path);
            this.subdirs.add(path);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void unregisterDirectory(Path path) {
        this.subdirs.remove(path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void traverseWatchedDirectories() throws IOException {
        List<FileWatchEventListener> list = this.eventListeners;
        synchronized (list) {
            Files.walkFileTree(this.watchPath, Collections.emptySet(), 2, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                    if (!dir.equals(FileWatcher.this.watchPath)) {
                        FileWatcher.this.directoryCreated(dir);
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fileCreated(Path path) {
        if (path.getParent().equals(this.watchPath)) {
            return;
        }
        List<FileWatchEventListener> list = this.eventListeners;
        synchronized (list) {
            for (FileWatchEventListener listener : this.eventListeners) {
                listener.fileCreated(path);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fileModified(Path path) {
        if (path.getParent().equals(this.watchPath)) {
            return;
        }
        List<FileWatchEventListener> list = this.eventListeners;
        synchronized (list) {
            for (FileWatchEventListener listener : this.eventListeners) {
                listener.fileModified(path);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fileDeleted(Path path) {
        if (path.getParent().equals(this.watchPath)) {
            return;
        }
        List<FileWatchEventListener> list = this.eventListeners;
        synchronized (list) {
            for (FileWatchEventListener listener : this.eventListeners) {
                listener.fileDeleted(path);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void directoryCreated(Path path) {
        if (!path.getParent().equals(this.watchPath)) {
            return;
        }
        List<FileWatchEventListener> list = this.eventListeners;
        synchronized (list) {
            this.registerDirectory(path);
            for (FileWatchEventListener listener : this.eventListeners) {
                listener.directoryCreated(path);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void directoryModified(Path path) {
        if (!path.getParent().equals(this.watchPath)) {
            return;
        }
        List<FileWatchEventListener> list = this.eventListeners;
        synchronized (list) {
            for (FileWatchEventListener listener : this.eventListeners) {
                listener.directoryModified(path);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void directoryDeleted(Path path) {
        if (!path.getParent().equals(this.watchPath)) {
            return;
        }
        List<FileWatchEventListener> list = this.eventListeners;
        synchronized (list) {
            this.unregisterDirectory(path);
            for (FileWatchEventListener listener : this.eventListeners) {
                listener.directoryDeleted(path);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            Object object;
            Object obj = Preparer.getObject();
            do {
                object = obj;
                synchronized (object) {
                    if (Preparer.initialized) {
                        break;
                    }
                    obj.wait(100L);
                }
            } while (!Preparer.initialized);
            do {
                object = this.watchPath;
                synchronized (object) {
                    if (instance != null) {
                        break;
                    }
                    this.watchPath.wait(100L);
                }
            } while (instance == null);
            this.registerWatchRoot(this.watchPath);
            this.traverseWatchedDirectories();
            this.monitoring();
        }
        catch (IOException | InterruptedException e) {
            EMLogger.printStackTrace(e);
        }
    }
}

