/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.emulator.manager.platform;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import org.tizen.emulator.manager.platform.EMPluginTree;
import org.tizen.emulator.manager.platform.Platform;
import org.tizen.emulator.manager.platform.PlatformStringResources;
import org.tizen.emulator.manager.platform.custom.CustomPlatformImageLoader;
import org.tizen.emulator.manager.plugin.EMPlugin;
import org.tizen.emulator.manager.resources.FilePathResources;

public class Preparer {
    public static boolean initialized = false;
    private static List<EMPlugin> pluginList = new ArrayList<EMPlugin>();

    public static Object getObject() {
        return pluginList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void execute() {
        if (initialized) {
            return;
        }
        Preparer.initVmsPath();
        Preparer.initPlatformList();
        List<EMPlugin> list = pluginList;
        synchronized (list) {
            initialized = true;
            pluginList.notifyAll();
        }
    }

    private static EMPlugin findEMPlugin(String name) {
        for (EMPlugin plugin : pluginList) {
            if (!plugin.getPluginName().equals(name)) continue;
            return plugin;
        }
        return null;
    }

    private static void initVmsPath() {
        String vms = FilePathResources.getTizenSDKDataVmsPath();
        Path vmsPath = Paths.get(vms, new String[0]);
        if (!Files.exists(vmsPath, new LinkOption[0])) {
            try {
                Files.createDirectories(vmsPath, new FileAttribute[0]);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private static void initPlatformList() {
        File platforms = new File(FilePathResources.getPlatformsPath());
        if (!platforms.exists() || !platforms.isDirectory()) {
            return;
        }
        File[] platformList = platforms.listFiles();
        if (platformList != null) {
            for (File platform : platformList) {
                File[] profileList;
                if (!platform.isDirectory() || (profileList = platform.listFiles()) == null) continue;
                for (File profileDir : profileList) {
                    EMPlugin plugin;
                    if (!profileDir.isDirectory() || (plugin = Preparer.makePlugin(profileDir)) == null) continue;
                    pluginList.add(plugin);
                }
            }
        }
        Preparer.initializePlugin();
        for (EMPlugin plugin : pluginList) {
            Preparer.makePlatform(plugin);
        }
        CustomPlatformImageLoader.initialize();
    }

    private static void initializePlugin() {
        EMPluginTree tree = new EMPluginTree();
        for (EMPlugin plugin : pluginList) {
            if (plugin.getBasePluginName() != null) {
                EMPlugin p = Preparer.findEMPlugin(plugin.getBasePluginName());
                if (p == null) continue;
                plugin.setBasePlugin(p);
                tree.addChild(p, plugin);
                continue;
            }
            tree.addRoot(plugin);
        }
        for (EMPlugin plugin : tree.getPlugins()) {
            plugin.initEMPlugin();
        }
    }

    private static void makePlatform(EMPlugin plugin) {
        File imagesDir = new File(plugin.getPlatformPath() + FilePathResources.getPlatformImagesSuffix());
        if (!imagesDir.exists()) {
            return;
        }
        if (!imagesDir.isDirectory()) {
            return;
        }
        File[] imageDirList = imagesDir.listFiles();
        if (imageDirList == null) {
            return;
        }
        for (File imageDir : imageDirList) {
            Platform platform;
            if (imageDir.isDirectory() && (platform = Platform.createStandardInstance(imageDir, plugin)) == null) continue;
        }
    }

    private static EMPlugin makePlugin(File profile) {
        File pluginDir = new File(profile.getAbsolutePath() + File.separator + FilePathResources.getPlatformPluginsSuffix());
        if (!pluginDir.exists() || !pluginDir.isDirectory()) {
            return null;
        }
        File pluginJar = null;
        File[] fileList = pluginDir.listFiles();
        if (fileList != null) {
            for (File file : fileList) {
                if (!file.getName().startsWith(PlatformStringResources.PLUGIN_PREFIX) || !file.getName().endsWith(PlatformStringResources.PLUGIN_EXTENSION)) continue;
                pluginJar = file;
                break;
            }
        }
        return EMPlugin.createInstance(pluginJar, profile.getAbsolutePath());
    }
}

