/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.emulator.manager.platform;

import org.tizen.emulator.manager.platform.ProfileList;

public class Profile
implements Comparable<Profile> {
    public static final String MOBILE = "mobile";
    public static final String WEARABLE = "wearable";
    public static final String TV = "tv";
    private final String name;
    private int priority = 0;

    private Profile(String name) {
        if (name == null || name.isEmpty()) {
            throw new IllegalArgumentException();
        }
        this.name = name;
        this.priority = name.equals(MOBILE) ? 0 : (name.equals(WEARABLE) ? 2 : (name.equals(TV) ? 4 : 10));
        ProfileList.getList().add(this);
    }

    public static Profile createNew(String name) {
        Profile profile = ProfileList.get(name);
        if (profile == null) {
            profile = new Profile(name);
        }
        return profile;
    }

    public String getName() {
        return this.name;
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public String toString() {
        return this.name;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Profile)) {
            return false;
        }
        Profile target = (Profile)obj;
        return target.getName().equals(this.name);
    }

    public int hashCode() {
        return 100;
    }

    @Override
    public int compareTo(Profile o) {
        return this.priority - o.getPriority();
    }
}

