/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.emulator.manager.ui.tabview.controller;

import org.tizen.emulator.manager.devices.DeviceTemplate;
import org.tizen.emulator.manager.devices.DeviceTemplateUtil;
import org.tizen.emulator.manager.platform.Platform;
import org.tizen.emulator.manager.ui.Messages;
import org.tizen.emulator.manager.ui.tabview.PropertyValue;
import org.tizen.emulator.manager.ui.tabview.STATE;
import org.tizen.emulator.manager.ui.tabview.controller.ComboViewController;
import org.tizen.emulator.manager.ui.tabview.controller.ViewItemController;
import org.tizen.emulator.manager.ui.tabview.event.Event;
import org.tizen.emulator.manager.ui.tabview.event.ItemEvent;
import org.tizen.emulator.manager.ui.template.item.Item;

public class DeviceTemplateComboController
extends ComboViewController {
    private String template = "";

    public DeviceTemplateComboController(Item item) {
        super(item);
    }

    @Override
    protected void onChangedValue(Event event) {
        ItemEvent iEvent = new ItemEvent("deviceTemplate", this);
        iEvent.oldValue = this.template;
        iEvent.newValue = event.text;
        iEvent.data = event.data;
        ViewItemController.sendChangeEvent(iEvent);
        this.template = event.text;
        this.checkValid();
    }

    @Override
    public void setIntializeValue(PropertyValue value) {
        Platform platform = (Platform)value.getObjectValue("baseImage");
        if (platform == null) {
            this.comboView.setEnable(false);
            return;
        }
        for (DeviceTemplate template : DeviceTemplateUtil.getDeviceTemplateListByPlatform(platform)) {
            this.comboView.addItem(template.getValue().getName(), template);
        }
        this.template = value.getStringValue("deviceTemplate");
        this.comboView.selectItem(this.template);
        this.checkValid();
    }

    @Override
    public void setPropertyValue(PropertyValue value) {
        value.setObjectValue("deviceTemplate", this.comboView.getSelectedData());
    }

    @Override
    public void checkValid() {
        String message = "";
        STATE newState = STATE.OK;
        if (this.comboView.getSelectedItem() == null) {
            newState = STATE.ERROR;
            message = Messages.getString("DeviceTemplateComboController.Error.0");
        }
        this.setItemState(newState, message);
    }
}

