/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.emulator.manager.ui.dialog;

import java.util.Optional;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Label;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.VBox;
import javafx.util.Callback;
import org.tizen.emulator.manager.ui.control.TizenCheckBox;
import org.tizen.emulator.manager.ui.dialog.CheckReturn;
import org.tizen.emulator.manager.ui.dialog.CustomDialog;
import org.tizen.emulator.manager.ui.dialog.MessageBoxButton;

public class MessageBox {
    public static ButtonType confirm(String message) {
        return MessageBox.confirm("Emulator Manager", message, ButtonType.OK);
    }

    public static ButtonType confirm(String title, String message) {
        return MessageBox.confirm(title, message, ButtonType.OK);
    }

    public static ButtonType confirm(String message, ButtonType type) {
        return MessageBox.confirm("Emulator Manager", message, type);
    }

    public static ButtonType confirm(String title, String message, ButtonType type) {
        CustomDialog dialog = new CustomDialog();
        dialog.setContentText(message);
        dialog.setTitle(title);
        dialog.getDialogPane().getButtonTypes().add((Object)ButtonType.CANCEL);
        dialog.getDialogPane().getButtonTypes().add((Object)type);
        Optional optType = dialog.showAndWait();
        if (optType.isPresent()) {
            return (ButtonType)optType.get();
        }
        return null;
    }

    public static ButtonType error(String message) {
        return MessageBox.error("Emulator Manager", message);
    }

    public static ButtonType error(String title, String message) {
        CustomDialog dialog = new CustomDialog();
        dialog.setContentText(message);
        dialog.setTitle(title);
        dialog.getDialogPane().getButtonTypes().add((Object)ButtonType.OK);
        Optional optType = dialog.showAndWait();
        if (optType.isPresent()) {
            return (ButtonType)optType.get();
        }
        return null;
    }

    public static CheckReturn check(String message, String checkMessage, boolean isChecked, ButtonType ... types) {
        MessageBoxButton[] buttons = new MessageBoxButton[types.length];
        for (int i = 0; i < types.length; ++i) {
            buttons[i] = new MessageBoxButton(types[i], "");
        }
        return MessageBox.check("Emulator Manager", message, checkMessage, isChecked, buttons);
    }

    public static CheckReturn check(String message, String checkMessage, ButtonType ... types) {
        return MessageBox.check(message, checkMessage, true, types);
    }

    public static CheckReturn check(String message, String checkMessage, boolean isChecked, MessageBoxButton ... buttons) {
        return MessageBox.check("Emulator Manager", message, checkMessage, isChecked, buttons);
    }

    public static CheckReturn check(String title, String message, String checkMessage, boolean isChecked, MessageBoxButton ... buttons) {
        CustomDialog dialog = new CustomDialog();
        VBox content = new VBox();
        content.getStyleClass().add((Object)"content-pane");
        Label labMsg = new Label(message);
        labMsg.getStyleClass().add((Object)"content-label");
        GridPane grid = new GridPane();
        grid.setPadding(new Insets(20.0, 20.0, 15.0, 15.0));
        final TizenCheckBox checkBox = new TizenCheckBox(checkMessage);
        checkBox.setSelected(isChecked);
        grid.add((Node)checkBox.getPane(), 1, 1);
        content.getChildren().add((Object)labMsg);
        content.getChildren().add((Object)grid);
        content.layout();
        dialog.getDialogPane().setContent((Node)content);
        dialog.setTitle(title);
        for (MessageBoxButton button : buttons) {
            dialog.getDialogPane().getButtonTypes().add((Object)button.buttonType);
        }
        for (MessageBoxButton button : buttons) {
            if (button.buttonText.isEmpty()) continue;
            Button btn = (Button)dialog.getDialogPane().lookupButton(button.buttonType);
            btn.setText(button.buttonText);
        }
        dialog.setResultConverter((Callback)new Callback<ButtonType, CheckReturn>(){

            public CheckReturn call(ButtonType param) {
                CheckReturn re = new CheckReturn();
                re.setButtonType(param);
                re.setChecked(checkBox.isSelected());
                return re;
            }
        });
        Optional optType = dialog.showAndWait();
        if (optType.isPresent()) {
            return (CheckReturn)optType.get();
        }
        return null;
    }
}

