/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.emulator.manager.plugin;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.Attributes;
import org.tizen.emulator.manager.logging.EMLogger;
import org.tizen.emulator.manager.platform.Profile;
import org.tizen.emulator.manager.platform.Version;
import org.tizen.emulator.manager.plugin.EMPluginLoader;
import org.tizen.emulator.manager.plugin.PluginStringResources;
import org.tizen.emulator.manager.resources.FilePathResources;

public class EMPlugin {
    private final String pluginName;
    private final File pluginJar;
    private final Attributes attr;
    private final Profile profile;
    private final Version version;
    private final String extension;
    private final String packageVersion;
    private final String emulatorDir;
    private final String platformDir;
    private EMPlugin parentPlugin;
    private ClassLoader loader;
    private final Map<String, Class<?>> extensionCls = new HashMap();

    public static EMPlugin createInstance(File pluginJar, String platformPath) {
        if (pluginJar == null || platformPath == null) {
            return null;
        }
        Attributes attr = EMPluginLoader.makeAttributes(pluginJar);
        if (attr == null) {
            return null;
        }
        if (attr.getValue("Platform-Profile") == null) {
            EMLogger.getLogger().warning("Can not found Platform-Profile attribute in " + pluginJar.getName() + ".");
            return null;
        }
        if (attr.getValue("Platform-Version") == null) {
            EMLogger.getLogger().warning("Can not found Platform-Version attribute in " + pluginJar.getName() + ".");
            return null;
        }
        if (attr.getValue("Base-Platform") != null && attr.getValue("Platform-Name") == null) {
            EMLogger.getLogger().warning("Platform Name is positively nescessary in Child Platform");
            return null;
        }
        return new EMPlugin(pluginJar, attr, platformPath);
    }

    private EMPlugin(File pluginJar, Attributes attr, String platformDir) {
        this.pluginJar = pluginJar;
        this.attr = attr;
        this.platformDir = platformDir;
        String profileName = this.getAttribute("Platform-Profile");
        this.profile = Profile.createNew(profileName);
        String version = this.getAttribute("Platform-Version");
        this.version = Version.createNew(version);
        String name = attr.getValue("Platform-Name");
        this.pluginName = name == null ? profileName + "-" + version : name;
        String ex = this.getAttribute("Extension");
        this.extension = ex == null ? "" : ex;
        String pVersion = this.getAttribute("Package-Version");
        this.packageVersion = pVersion == null || pVersion.isEmpty() ? "undefined" : pVersion;
        String path = this.getAttribute("Emulator-Dir");
        if (path != null) {
            File file = new File(path);
            if (!file.isAbsolute()) {
                path = FilePathResources.getTizenSDKPath() + File.separator + path;
            }
        } else {
            path = FilePathResources.getPlatformEmulatorPath(this.version.getValue());
        }
        this.emulatorDir = path;
    }

    public boolean initEMPlugin() {
        ClassLoader parentLoader = null;
        parentLoader = this.parentPlugin != null ? this.parentPlugin.getLoader() : EMPlugin.class.getClassLoader();
        this.loader = EMPluginLoader.makeLoader(this.pluginJar, parentLoader);
        if (this.loader == null) {
            return false;
        }
        this.prepareExtensionClass();
        this.prepareLegacyEndpoint();
        return true;
    }

    public String getPluginName() {
        return this.pluginName;
    }

    public Profile getProfile() {
        return this.profile;
    }

    public Version getVersion() {
        return this.version;
    }

    public String getExtension() {
        return this.extension;
    }

    public String getPackageVersion() {
        return this.packageVersion;
    }

    public EMPlugin getBasePlugin() {
        return this.parentPlugin;
    }

    public void setBasePlugin(EMPlugin basePlugin) {
        this.parentPlugin = basePlugin;
    }

    public String getBasePluginName() {
        return this.attr.getValue("Base-Platform");
    }

    public ClassLoader getLoader() {
        return this.loader;
    }

    public String getPlatformPath() {
        return this.platformDir;
    }

    public String getEmulatorDir() {
        return this.emulatorDir;
    }

    public String getAttribute(String key) {
        if (this.attr == null) {
            return null;
        }
        return this.attr.getValue(key);
    }

    public Class<?> getExtensionClass(String pointName) {
        return this.extensionCls.get(pointName);
    }

    public Object newInstance(String pointName) {
        Class<?> cls = null;
        try {
            cls = this.getExtensionClass(pointName);
            if (cls != null) {
                return cls.newInstance();
            }
        }
        catch (IllegalAccessException | InstantiationException e) {
            e.printStackTrace();
            EMLogger.getLogger().warning("Extension class [" + cls.getName() + "] can not be instantiated.");
        }
        return null;
    }

    private void prepareExtensionClass() {
        for (Object attribute : this.attr.keySet()) {
            String clsName;
            String key = ((Attributes.Name)attribute).toString();
            if (!key.startsWith("Extension-") || (clsName = this.attr.getValue(key)) == null) continue;
            try {
                Class<?> cls = this.loader.loadClass(clsName);
                this.extensionCls.put(key, cls);
            }
            catch (ClassNotFoundException e) {
                EMLogger.printStackTrace(e);
                EMLogger.getLogger().warning("Extension class [" + clsName + "] is not found in " + this.pluginJar.getName() + ".");
            }
            catch (Throwable e) {
                EMLogger.printStackTrace(e);
            }
        }
    }

    private void prepareLegacyEndpoint() {
        String pointClass = null;
        for (String ex : PluginStringResources.getPointList()) {
            pointClass = this.attr.getValue(ex);
            if (pointClass == null) continue;
            try {
                Class<?> cls = this.loader.loadClass(pointClass);
                this.extensionCls.put(ex, cls);
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
                EMLogger.getLogger().warning("Extension class [" + pointClass + "] is not found in " + this.pluginJar.getName() + ".");
            }
            catch (Throwable e) {
                EMLogger.printStackTrace(e);
            }
        }
    }

    public void printInformation() {
        System.out.println("Name:" + this.pluginName);
        System.out.println("Profile: " + this.profile.getName());
        System.out.println("Version: " + this.version.getValue());
        System.out.println("Extension: " + this.extension);
        System.out.println("Package Version:" + this.packageVersion);
        System.out.println("Emulator Dir:" + this.emulatorDir);
        System.out.println("Platform Path: " + this.platformDir);
        if (this.parentPlugin != null) {
            System.out.println("Parent: " + this.parentPlugin.getPluginName());
        }
    }

    public Class<?> getOCIClass() {
        Class<?> ociClass = null;
        try {
            ociClass = this.loader.loadClass("org.tizen.emulator.manager.tv.samsung.ui.detail.EnumerationOCI");
        }
        catch (ClassNotFoundException e) {
            EMLogger.getLogger().warning("Extension class [EnumerationOCI] is not found in " + this.pluginJar.getName());
        }
        return ociClass;
    }
}

