/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.emulator.manager.vms.property;

import java.io.File;
import org.tizen.emulator.manager.concurrent.overseer.CheckWebcam;
import org.tizen.emulator.manager.resources.FilePathResources;
import org.tizen.emulator.manager.vms.VMPropertyValue;

public class CameraProperty {
    private static final String DEFAULT_FRONT_IMG = "default-image1.gif";
    private static final String DEFAULT_REAR_IMG = "default-image2.gif";

    public static void setDefault(VMPropertyValue value, boolean isRear) {
        String cameraType = CameraProperty.getDefaultCameraType(isRear);
        String typeItemName = isRear ? "rearType" : "frontType";
        value.setAdvancedSubOption("camera", typeItemName, cameraType);
        if (cameraType.equals("Virtual")) {
            String imageItemName = isRear ? "rearImage" : "frontImage";
            value.setAdvancedSubOption("camera", imageItemName, CameraProperty.getDefaultImagePath(isRear));
        }
    }

    public static String getDefaultCameraType(boolean isRear) {
        if (isRear && CheckWebcam.isWebcamSupport()) {
            return "Webcam";
        }
        return "Virtual";
    }

    public static String getDefaultImagePath(boolean isRear) {
        return FilePathResources.getToolEmulatorImagesPath() + File.separator + (isRear ? DEFAULT_REAR_IMG : DEFAULT_FRONT_IMG);
    }
}

