/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.emulator.manager.vms;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystemException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import org.tizen.emulator.manager.EmulatorManager;
import org.tizen.emulator.manager.Messages;
import org.tizen.emulator.manager.concurrent.SimpleExecutor;
import org.tizen.emulator.manager.logging.EMLogger;
import org.tizen.emulator.manager.resources.FilePathResources;
import org.tizen.emulator.manager.resources.StringResources;
import org.tizen.emulator.manager.vms.VMProperty;
import org.tizen.emulator.manager.vms.VMPropertyValue;
import org.tizen.emulator.manager.vms.exception.VMCreatorException;
import org.tizen.emulator.manager.vms.exception.VMWorkerException;
import org.tizen.emulator.manager.vms.helper.QemuImgProc;

public class Creator {
    private VMPropertyValue newVM;
    private Path vmsPath;
    private String customPath;
    private String swapPath;

    private Creator() {
    }

    private Creator(VMPropertyValue newVM) {
        this.newVM = newVM;
        this.vmsPath = Paths.get(FilePathResources.getVirtualTargetPath(newVM.vmName), new String[0]);
    }

    private VMProperty createLocked() throws VMWorkerException {
        VMProperty property = null;
        try {
            if (Files.exists(this.vmsPath, new LinkOption[0])) {
                throw new VMWorkerException(Messages.getString("Creator.Error.1"), true);
            }
        }
        catch (VMWorkerException e) {
            EMLogger.getLogger().warning("Failed to create the VM: " + e.getMessage());
            throw e;
        }
        try {
            try {
                Files.createDirectories(Paths.get(FilePathResources.getVirtualTargetLogPath(this.newVM.vmName), new String[0]), new FileAttribute[0]);
                Files.createDirectories(this.vmsPath, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new VMCreatorException("Create VM path failed.");
            }
            this.createSwapImage();
            if (this.newVM.useQCOW2()) {
                this.createDiskImage();
            }
            this.createFileShare();
            this.createDisplay();
            this.createRam();
            this.createUsability();
        }
        catch (VMCreatorException e) {
            try {
                this.deleteFolder(this.vmsPath);
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            EMLogger.getLogger().warning("Failed to create the VM: " + e.getMessage());
            throw e;
        }
        property = EmulatorManager.getVMKeeper().createProperty(this.newVM);
        Path lastCreatedpropertyFile = Paths.get(Creator.getLastCreatedPropertyPath(this.newVM.getProfile()), new String[0]);
        Path resultPath = null;
        while (resultPath == null && Files.isRegularFile(property.getPropertyFile(), new LinkOption[0])) {
            try {
                resultPath = Files.copy(property.getPropertyFile(), lastCreatedpropertyFile, StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.COPY_ATTRIBUTES);
            }
            catch (FileSystemException e) {
                EMLogger.getLogger().info(e.getMessage());
            }
            catch (IOException e) {
                EMLogger.getLogger().warning("Failed to create last-created property file.");
                e.printStackTrace();
            }
        }
        EMLogger.getLogger().info("Success to create the " + property.getPropertyValue().vmName + " VM");
        return property;
    }

    private static String getLastCreatedPropertyPath(String profile) {
        StringBuilder sb = new StringBuilder();
        sb.append(FilePathResources.getTizenSDKDataVmsPath()).append(File.separator).append("last-created").append("_").append(profile).append(".xml");
        return sb.toString();
    }

    private void deleteFolder(Path directory) throws IOException {
        Files.walkFileTree(directory, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                Files.delete(file);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                Files.delete(dir);
                return FileVisitResult.CONTINUE;
            }
        });
    }

    private void createDiskImage() throws VMCreatorException {
        String baseImagePath = this.newVM.getDiskImagePath();
        if (baseImagePath == null || baseImagePath.isEmpty()) {
            throw new VMCreatorException(Messages.getString("Creator.ImageError.0") + StringResources.NEW_LINE);
        }
        if (!new File(baseImagePath).exists()) {
            throw new VMCreatorException(Messages.getString("Creator.ImageError.0") + StringResources.NEW_LINE + baseImagePath);
        }
        this.checkCustomBaseImage(baseImagePath);
        this.customPath = this.vmsPath + File.separator + "emulimg-" + this.newVM.vmName + "." + this.newVM.getImageArch().toString();
        this.createInitialVMImageInternal(baseImagePath, this.customPath);
        this.newVM.childImagePath = this.customPath;
    }

    private void createSwapImage() throws VMCreatorException {
        String swap_base_path = FilePathResources.getToolEmulatorSwapImagePath() + File.separator + "swap.img";
        if (!new File(swap_base_path).exists()) {
            return;
        }
        this.swapPath = this.vmsPath + File.separator + "swap-" + this.newVM.vmName + ".img";
        this.createSwapImageInternal(swap_base_path, this.swapPath);
        this.newVM.swapImagePath = this.swapPath;
    }

    private void createSwapImageInternal(String basePath, String targetPath) throws VMCreatorException {
        try {
            Files.copy(Paths.get(basePath, new String[0]), Paths.get(targetPath, new String[0]), StandardCopyOption.COPY_ATTRIBUTES);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new VMCreatorException(Messages.getString("Creator.SwapImageError.0") + StringResources.NEW_LINE + Messages.getString("Creator.SwapImageError.1") + FilePathResources.getTizenSDKDataVmsPath() + File.separator + "emulator-manager)");
        }
    }

    private void checkCustomBaseImage(String path) throws VMCreatorException {
        String exe_path = this.getQemuImgPath();
        ArrayList<String> cmd = new ArrayList<String>();
        cmd.add(exe_path);
        cmd.add("info");
        cmd.add(path);
        String errorMsg = new QemuImgProc(cmd).runningForCheckImg();
        if (errorMsg != null) {
            throw new VMCreatorException(errorMsg);
        }
    }

    public void createInitialVMImageInternal(String baseImagePath, String targetImagePath) throws VMCreatorException {
        String exe_path = this.getQemuImgPath();
        ArrayList<String> cmd = new ArrayList<String>();
        cmd.add(exe_path);
        cmd.add("create");
        cmd.add("-b");
        cmd.add(baseImagePath);
        cmd.add("-f");
        cmd.add("qcow2");
        cmd.add(targetImagePath);
        if (!new QemuImgProc(cmd).running()) {
            throw new VMCreatorException(Messages.getString("Creator.Qemu-imgError.0") + StringResources.NEW_LINE + Messages.getString("Creator.Qemu-imgError.1") + FilePathResources.getTizenSDKDataVmsPath() + File.separator + "emulator-manager)");
        }
    }

    private void createFileShare() throws VMCreatorException {
        if (this.newVM.isFileShareSupport) {
            if (this.newVM.fileSharePath == null || this.newVM.fileSharePath.isEmpty()) {
                throw new VMCreatorException(Messages.getString("Creator.FileShareError.0"));
            }
            File file = new File(this.newVM.fileSharePath);
            if (!file.exists()) {
                throw new VMCreatorException(Messages.getString("Creator.FileShareError.1"));
            }
        }
    }

    private void createDisplay() throws VMCreatorException {
    }

    private void createRam() {
    }

    private void createUsability() {
    }

    public static VMProperty create(final VMPropertyValue newVM) throws VMWorkerException {
        VMProperty property = null;
        try {
            property = SimpleExecutor.lockedExecute(new Callable<VMProperty>(){

                @Override
                public VMProperty call() throws Exception {
                    return new Creator(newVM).createLocked();
                }
            });
        }
        catch (VMWorkerException e) {
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return property;
    }

    public static void createInitialVMImage(String basePath, String targetPath) throws VMCreatorException {
        new Creator().createInitialVMImageInternal(basePath, targetPath);
    }

    public static void createSwapImage(String basePath, String targetPath) throws VMWorkerException {
        new Creator().createSwapImageInternal(basePath, targetPath);
    }

    private String getQemuImgPath() {
        return FilePathResources.getEmulatorQemuImgPath();
    }
}

