/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.emulator.manager.vms;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.tizen.emulator.manager.devices.DeviceTemplate;
import org.tizen.emulator.manager.devices.DeviceTemplateValue;
import org.tizen.emulator.manager.devices.SubDevice;
import org.tizen.emulator.manager.devices.SubDeviceItem;
import org.tizen.emulator.manager.devices.SubDeviceValue;
import org.tizen.emulator.manager.logging.EMLogger;
import org.tizen.emulator.manager.platform.Platform;
import org.tizen.emulator.manager.platform.Skin;
import org.tizen.emulator.manager.platform.StandardPlatform;
import org.tizen.emulator.manager.resources.FilePathResources;
import org.tizen.emulator.manager.resources.StringResources;
import org.tizen.emulator.manager.vms.DiskImageFormat;
import org.tizen.emulator.manager.vms.VMOption;
import org.tizen.emulator.manager.vms.VMProperty;
import org.tizen.emulator.manager.vms.option.CommonOptionUtil;
import org.tizen.emulator.manager.vms.option.IOption;
import org.tizen.emulator.manager.vms.type.Architecture;
import org.tizen.emulator.manager.vms.type.FSImageType;
import org.tizen.emulator.manager.vms.type.OCI;
import org.tizen.emulator.manager.vms.type.RESOLUTION;

public class VMPropertyValue {
    private DeviceTemplate device;
    public String devicePath = "";
    public String deviceName = "";
    public double deivceVersion = 1.0;
    private Platform platform;
    private VMProperty property;
    public String vmName = "";
    public String childImagePath;
    public String swapImagePath;
    public RESOLUTION resolution;
    public int dpi = RESOLUTION.HD.getDPI();
    public double screenSize = 0.0;
    public Skin skin;
    public String skinPath = "";
    public int ramSize = 512;
    public int cpu = 1;
    public boolean isFileShareSupport;
    public String fileSharePath = "";
    public boolean isHWVirtualization;
    public boolean isGLAcceleration;
    private static int MAX_TOUCH = 10;
    public int maxTouchCount = MAX_TOUCH;
    public OCI ociDevice;
    public String ociOptions;
    public boolean isSupportSuspend;
    boolean isBinaryVersionMatched = true;
    public List<VMOption> advancedVMOptionList = new ArrayList<VMOption>();
    public static final String HOST_IP = "hostIp";
    private List<IOption> optionList = null;

    public static VMPropertyValue createValueForNewVM(Platform platform) {
        return VMPropertyValue.createValueForNewVM(platform, platform.getDefaultProperty());
    }

    public static VMPropertyValue createValueForNewVM(Platform platform, VMProperty property) {
        VMPropertyValue newValue = new VMPropertyValue(property.getPropertyValue());
        newValue.property = property;
        newValue.setPlatform(platform);
        return newValue;
    }

    public static VMPropertyValue createValueForNewVM(Platform platform, VMProperty property, String vmName) {
        VMPropertyValue newValue = new VMPropertyValue(property.getPropertyValue());
        if (vmName == null || vmName.isEmpty()) {
            throw new NullPointerException();
        }
        newValue.property = property;
        newValue.vmName = vmName;
        newValue.setPlatform(platform);
        return newValue;
    }

    public VMPropertyValue(VMProperty property) {
        assert (property != null);
        if (property != null) {
            this.property = property;
        } else {
            EMLogger.getLogger().warning("Failed to create VMPropertyValue because property is null");
        }
    }

    public VMProperty getVMProperty() {
        return this.property;
    }

    public Platform getPlatform() {
        return this.platform;
    }

    public void setPlatform(Platform platform) {
        this.platform = platform;
        this.settingSkin();
    }

    public String getLockFilePath() {
        return FilePathResources.getVirtualTargetPath(this.vmName) + File.separator + "vm.lock";
    }

    public String getDiskImagePath() {
        if (this.platform == null) {
            return "";
        }
        List<String> pathList = this.platform.getImagePathList();
        assert (pathList.size() > 0);
        return pathList.get(0);
    }

    public List<String> getImagePathList() {
        if (this.platform != null) {
            return this.platform.getImagePathList();
        }
        return new ArrayList<String>();
    }

    public DiskImageFormat getImageFormat() {
        if (this.platform != null) {
            return this.platform.getImageFormat();
        }
        return DiskImageFormat.QCOW2;
    }

    public String getImageBinaryVersion() {
        if (this.platform != null) {
            return this.platform.getImageBinaryVersion();
        }
        return "";
    }

    public String getImageVersion() {
        if (this.platform != null) {
            return this.platform.getVersion().getValue();
        }
        return "";
    }

    public Architecture getImageArch() {
        if (this.platform != null) {
            return this.platform.getImageArch();
        }
        return Architecture.x86;
    }

    public boolean isStandardImage() {
        if (this.platform != null) {
            return this.platform instanceof StandardPlatform;
        }
        return false;
    }

    public String getProfile() {
        if (this.platform != null) {
            return this.platform.getProfile().getName();
        }
        return "";
    }

    public String getProfileExtension() {
        if (this.platform != null) {
            return this.platform.getExtension();
        }
        return "";
    }

    public String getImageName() {
        if (this.platform != null) {
            return this.platform.getImageName();
        }
        return "";
    }

    public String getPlatformName() {
        if (this.platform != null) {
            return this.platform.getName();
        }
        return "";
    }

    public boolean useQCOW2() {
        if (this.platform != null) {
            return this.platform.getImageFormat() == DiskImageFormat.QCOW2;
        }
        return true;
    }

    public FSImageType getImageType() {
        if (this.platform != null) {
            if (this.platform instanceof StandardPlatform) {
                return FSImageType.standard;
            }
            return FSImageType.custom;
        }
        return FSImageType.custom;
    }

    public Architecture getArch() {
        if (this.platform != null) {
            return Architecture.getDisplayType(this.platform.getImageArch().toString());
        }
        return Architecture.x86;
    }

    public VMPropertyValue(VMPropertyValue value) {
        this.device = value.device;
        this.deviceName = value.deviceName;
        this.devicePath = value.devicePath;
        this.deivceVersion = value.deivceVersion;
        this.platform = value.platform;
        this.property = value.property;
        this.vmName = value.vmName;
        this.childImagePath = value.childImagePath;
        this.swapImagePath = value.swapImagePath;
        this.resolution = value.resolution;
        this.dpi = value.dpi;
        this.screenSize = value.screenSize;
        this.skin = value.skin;
        this.skinPath = value.skinPath;
        this.ramSize = value.ramSize;
        this.cpu = value.cpu;
        this.isFileShareSupport = value.isFileShareSupport;
        this.fileSharePath = value.fileSharePath;
        this.isHWVirtualization = value.isHWVirtualization;
        this.isGLAcceleration = value.isGLAcceleration;
        this.maxTouchCount = value.maxTouchCount;
        this.ociOptions = value.ociOptions;
        this.isSupportSuspend = value.isSupportSuspend;
        for (VMOption src : value.advancedVMOptionList) {
            this.advancedVMOptionList.add(new VMOption(src));
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof VMPropertyValue)) {
            return false;
        }
        VMPropertyValue dest = (VMPropertyValue)obj;
        if (this.device != dest.device) {
            return false;
        }
        if (!this.deviceName.equals(dest.deviceName)) {
            return false;
        }
        if (!this.devicePath.equals(dest.devicePath)) {
            return false;
        }
        if (!this.resolution.toString().equals(dest.resolution.toString())) {
            return false;
        }
        if (this.dpi != dest.dpi) {
            return false;
        }
        if (this.screenSize != dest.screenSize) {
            return false;
        }
        if (this.skin != dest.skin) {
            return false;
        }
        if (this.ramSize != dest.ramSize) {
            return false;
        }
        if (this.cpu != dest.cpu) {
            return false;
        }
        if (this.isFileShareSupport != dest.isFileShareSupport) {
            return false;
        }
        if (!this.fileSharePath.equals(dest.fileSharePath)) {
            return false;
        }
        if (this.isHWVirtualization != dest.isHWVirtualization) {
            return false;
        }
        if (this.isGLAcceleration != dest.isGLAcceleration) {
            return false;
        }
        if (this.platform != null ? dest.platform == null || !this.platform.getName().equals(dest.platform.getName()) : dest.platform != null) {
            return false;
        }
        if (this.maxTouchCount != dest.maxTouchCount) {
            return false;
        }
        if (this.ociOptions != null ? dest.ociOptions == null || !this.ociOptions.equals(dest.ociOptions) : dest.ociOptions != null) {
            return false;
        }
        if (this.isSupportSuspend != dest.isSupportSuspend) {
            return false;
        }
        return this.isAdvancedOptionEquals(dest.advancedVMOptionList);
    }

    public int hashCode() {
        return 100;
    }

    private void settingSkin() {
        if (this.skinPath == null) {
            this.skin = null;
            return;
        }
        this.skin = this.platform.getSkinByPath(this.skinPath);
        if (this.skin == null) {
            try {
                this.skin = new Skin(new File(this.skinPath));
            }
            catch (IOException e) {
                this.skin = null;
                EMLogger.getLogger().warning("Failed to create skin." + StringResources.NEW_LINE + e.getMessage());
            }
        }
    }

    public DeviceTemplate getDeviceTemplate() {
        return this.device;
    }

    public void setDeviceTemplateInfo(DeviceTemplate device) {
        if (device == null) {
            return;
        }
        this.device = device;
        this.devicePath = device.getTemplateFile().getAbsolutePath();
        this.deviceName = device.getValue().getName();
        this.deivceVersion = device.getValue().getVersion();
    }

    public void setDeviceTemplate(DeviceTemplate device) {
        if (device == null) {
            return;
        }
        this.setDeviceTemplateInfo(device);
        DeviceTemplateValue value = device.getValue();
        if (value.getSkin() != null) {
            this.skin = value.getSkin();
            this.skinPath = value.getSkinPath();
        }
        this.resolution = value.getResolution();
        this.dpi = value.getDisplayDPI();
        this.screenSize = value.getDisplaySize();
        for (SubDevice subDevice : value.getAdditionalDevices()) {
            for (SubDeviceItem subItem : subDevice.getItems()) {
                this.setAdvancedSubOption(subDevice.getName(), subItem.getId(), subItem.isSupport() ? "on" : "off");
            }
            for (SubDeviceValue subValue : subDevice.getValues()) {
                this.setAdvancedSubOption(subDevice.getName(), subValue.getName(), subValue.getValue());
            }
        }
    }

    public VMOption getAdvancedOption(String optionName) {
        for (VMOption option : this.advancedVMOptionList) {
            if (!option.getName().equals(optionName)) continue;
            return option;
        }
        return null;
    }

    @Deprecated
    public VMOption getVMAdvancedOption(String optionName) {
        return this.getAdvancedOption(optionName);
    }

    public void setAdvancedOption(String name, String value) {
        VMOption old = this.getAdvancedOption(name);
        if (old != null) {
            this.advancedVMOptionList.remove(old);
        }
        VMOption option = new VMOption(name);
        option.setValue(value);
        this.advancedVMOptionList.add(option);
    }

    public void setAdvancedSubOption(String name, String subName, String subValue) {
        VMOption oldOption;
        VMOption option = this.getAdvancedOption(name);
        if (option == null) {
            option = new VMOption(name);
            option.setValue(null);
            this.advancedVMOptionList.add(option);
        }
        if ((oldOption = option.getSubOption(subName)) != null) {
            option.getSubOptionList().remove(oldOption);
        }
        VMOption subOption = new VMOption(subName, subValue);
        option.addSubOption(subOption);
    }

    public String getAdvancedOptionValue(String optionName) {
        for (VMOption option : this.advancedVMOptionList) {
            if (!option.getName().equals(optionName)) continue;
            return option.getValue();
        }
        return "";
    }

    public String getAdvancedSubOptionValue(String name, String subName) {
        VMOption option = this.getAdvancedOption(name);
        if (option == null) {
            return "";
        }
        VMOption subOption = option.getSubOption(subName);
        if (subOption == null) {
            return "";
        }
        return subOption.getValue();
    }

    @Deprecated
    public String getAdvancedOptionSubValue(String name, String subName) {
        return this.getAdvancedSubOptionValue(name, subName);
    }

    public List<VMOption> getAdvancedOptionList() {
        return this.advancedVMOptionList;
    }

    private boolean isAdvancedOptionEquals(List<VMOption> destList) {
        return VMOption.isOptionListEquals(this.advancedVMOptionList, destList);
    }

    public List<IOption> getOptionList() {
        if (this.optionList == null) {
            this.optionList = CommonOptionUtil.getOptionList(this.getPlatform(), this);
        }
        return this.optionList;
    }
}

