/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.emulator.manager.plugin;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import org.tizen.emulator.manager.logging.EMLogger;

public class EMPluginLoader
extends URLClassLoader {
    private EMPluginLoader(URL url) throws MalformedURLException {
        super(new URL[]{url});
    }

    private EMPluginLoader(URL url, ClassLoader parent) throws MalformedURLException {
        super(new URL[]{url}, parent);
    }

    public static ClassLoader makeLoader(File plugin, final ClassLoader parent) {
        URL url = null;
        try {
            url = plugin.toURI().toURL();
            if (url == null) {
                throw new MalformedURLException();
            }
            final URL urlwork = url;
            if (parent == null) {
                return AccessController.doPrivileged(new PrivilegedAction<EMPluginLoader>(){

                    @Override
                    public EMPluginLoader run() {
                        try {
                            return new EMPluginLoader(urlwork);
                        }
                        catch (MalformedURLException e) {
                            e.printStackTrace();
                            return null;
                        }
                    }
                });
            }
            return AccessController.doPrivileged(new PrivilegedAction<EMPluginLoader>(){

                @Override
                public EMPluginLoader run() {
                    try {
                        return new EMPluginLoader(urlwork, parent);
                    }
                    catch (MalformedURLException e) {
                        e.printStackTrace();
                        return null;
                    }
                }
            });
        }
        catch (MalformedURLException e) {
            EMLogger.getLogger().warning("Failed to load url from jar file: " + e.getMessage());
            return null;
        }
    }

    public static void closeFile(JarFile jarFile) {
        if (jarFile != null) {
            try {
                jarFile.close();
            }
            catch (IOException e) {
                EMLogger.getLogger().info(e.getMessage());
            }
        }
    }

    public static Attributes makeAttributes(File pluginJar) {
        JarFile jarFile = null;
        Attributes attr = null;
        try {
            jarFile = new JarFile(pluginJar.getAbsolutePath());
        }
        catch (IOException e) {
            EMLogger.log("Failed to load plugin jar file: " + e.getMessage());
        }
        try {
            if (jarFile != null && jarFile.getManifest() != null) {
                attr = jarFile.getManifest().getMainAttributes();
            }
        }
        catch (IOException e) {
            EMLogger.log("Failed to load Manifest file: " + e.getMessage());
            EMPluginLoader.closeFile(jarFile);
            return null;
        }
        EMPluginLoader.closeFile(jarFile);
        return attr;
    }

    @Override
    public URL getResource(String name) {
        URL url = this.findResource(name);
        if (url != null) {
            return url;
        }
        return super.getResource(name);
    }
}

