/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.emulator.manager.ui.controller.create;

import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.input.MouseEvent;
import javafx.util.Callback;
import org.tizen.emulator.manager.ui.control.TizenCheckBox;
import org.tizen.emulator.manager.ui.controller.create.PlatformItem;

class PlatformCheckBoxCell
extends TableCell<PlatformItem, Boolean> {
    TizenCheckBox checkBox = new TizenCheckBox();
    EventHandler<MouseEvent> handler = new EventHandler<MouseEvent>(){

        public void handle(MouseEvent event) {
            if (event.getEventType() == MouseEvent.MOUSE_PRESSED) {
                if (event.isShiftDown()) {
                    return;
                }
                PlatformCheckBoxCell.this.toggleSelection();
                event.consume();
            } else if (event.getEventType() == MouseEvent.MOUSE_RELEASED) {
                event.consume();
            }
        }
    };

    PlatformCheckBoxCell() {
    }

    void toggleSelection() {
        TableView tableView = this.getTableView();
        if (tableView == null) {
            return;
        }
        int rowIndex = this.getTableRow().getIndex();
        if (this.checkBox.isSelected()) {
            tableView.getSelectionModel().clearSelection(rowIndex);
        } else if (tableView.getSelectionModel().getSelectedIndices().size() == 0) {
            tableView.getSelectionModel().clearAndSelect(rowIndex);
        } else {
            tableView.getSelectionModel().select(rowIndex);
        }
    }

    protected void updateItem(Boolean item, boolean empty) {
        super.updateItem((Object)item, empty);
        if (this.isEmpty()) {
            this.setText(null);
            this.setTooltip(null);
            this.setGraphic(null);
            return;
        }
        this.checkBox.setSelected(item);
        this.checkBox.setSpacing(0.0);
        this.setGraphic((Node)this.checkBox.getPane());
        this.addEventFilter(MouseEvent.MOUSE_PRESSED, this.handler);
        this.addEventFilter(MouseEvent.MOUSE_RELEASED, this.handler);
        this.getStyleClass().add((Object)"table-checkbox-cell");
    }

    static Callback<TableColumn<PlatformItem, Boolean>, TableCell<PlatformItem, Boolean>> extractor() {
        return new Callback<TableColumn<PlatformItem, Boolean>, TableCell<PlatformItem, Boolean>>(){

            public TableCell<PlatformItem, Boolean> call(TableColumn<PlatformItem, Boolean> param) {
                return new PlatformCheckBoxCell();
            }
        };
    }
}

