/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.emulator.manager.console;

import java.util.ArrayList;
import org.tizen.emulator.manager.console.Option;

public abstract class Command {
    protected String command = null;
    protected ArrayList<Option> optionList = new ArrayList();
    protected String description = null;
    protected String shortDescription = null;
    protected String usage = null;
    protected boolean isInternalCommand = false;

    public abstract boolean process();

    public String getCommand() {
        assert (this.command != null);
        return this.command;
    }

    public String getDescription() {
        assert (this.description != null);
        return this.description;
    }

    public String getShortDescription() {
        if (this.shortDescription == null) {
            return this.description;
        }
        return this.shortDescription;
    }

    public String getUsage() {
        assert (this.usage != null);
        return this.usage;
    }

    public ArrayList<Option> getOptionList() {
        assert (this.optionList != null);
        return this.optionList;
    }

    public String checkMandatory() {
        if (this.optionList == null) {
            return null;
        }
        String message = null;
        for (Option c : this.optionList) {
            if (c == null || !c.isMandatory() || c.isInCommandLine()) continue;
            message = "--" + c.getLongName() + "(-" + c.getShortName() + ")";
        }
        return message;
    }

    public Option findOption(String a) {
        if (this.optionList == null) {
            return null;
        }
        for (Option c : this.optionList) {
            if (c == null) continue;
            if (c.getLongName().equals(a)) {
                return c;
            }
            if (!c.getShortName().equals(a)) continue;
            return c;
        }
        return null;
    }

    public Option findLongNameOption(String a) {
        if (this.optionList == null) {
            return null;
        }
        for (Option c : this.optionList) {
            if (c == null || !c.getLongName().equals(a)) continue;
            return c;
        }
        return null;
    }

    public Option findShortNameOption(String a) {
        if (this.optionList == null) {
            return null;
        }
        for (Option c : this.optionList) {
            if (c == null || !c.getShortName().equals(a)) continue;
            return c;
        }
        return null;
    }

    public boolean isInternalCommand() {
        return this.isInternalCommand;
    }
}

