/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.emulator.manager.vms.helper;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.Random;
import java.util.logging.Level;
import org.tizen.emulator.manager.EmulatorManager;
import org.tizen.emulator.manager.Messages;
import org.tizen.emulator.manager.devices.DeviceTemplateUtil;
import org.tizen.emulator.manager.devices.DeviceTemplateValue;
import org.tizen.emulator.manager.logging.EMLogger;
import org.tizen.emulator.manager.platform.Platform;
import org.tizen.emulator.manager.platform.PlatformList;
import org.tizen.emulator.manager.resources.FilePathResources;
import org.tizen.emulator.manager.resources.StringResources;
import org.tizen.emulator.manager.tool.OSUtil;
import org.tizen.emulator.manager.vms.VMProperty;
import org.tizen.emulator.manager.vms.VMPropertyValue;
import org.tizen.emulator.manager.vms.exception.EmptyStringException;
import org.tizen.emulator.manager.vms.exception.VMWorkerException;
import org.tizen.emulator.manager.vms.helper.ProcessOutputReader;
import org.tizen.emulator.manager.vms.helper.ProcessResult;

public class HelperClass {
    private static Random rd = new Random();
    public static String loaclIPAddress = "(your IP)";
    static final int EXIT_VALUE_PROCESS_STARTED_FAILURE = -1;

    public static String checkVMName(String name) throws VMWorkerException, EmptyStringException {
        if (name == null || name.isEmpty()) {
            throw new EmptyStringException(Messages.getString("HelperClass.Error.VMName.Empty"));
        }
        if (name.length() > 30) {
            throw new VMWorkerException(Messages.getString("HelperClass.Error.VMName.MaxLength") + Integer.toString(30));
        }
        if (!HelperClass.checkStringOfVMName(name)) {
            throw new VMWorkerException("\"" + name + "\" " + Messages.getString("HelperClass.Error.VMName.Invalid.1") + StringResources.NEW_LINE + Messages.getString("HelperClass.Error.VMName.Invalid.2") + "A-Za-z0-9-_");
        }
        if (!HelperClass.checkDuplicateName(name)) {
            throw new VMWorkerException(name + " " + Messages.getString("HelperClass.Error.VMName.Exist"));
        }
        return name;
    }

    public static boolean checkStringOfVMName(String t) {
        for (char ch : t.toCharArray()) {
            if (ch >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z' || ch >= '0' && ch <= '9' || ch == '-' || ch == '_') continue;
            return false;
        }
        return true;
    }

    public static boolean checkDuplicateName(String name) {
        boolean isWindows = false;
        if (OSUtil.isWin()) {
            isWindows = true;
            name = name.toLowerCase();
        }
        for (VMProperty property : EmulatorManager.getVMKeeper().getProperties()) {
            if (!(isWindows ? property.getPropertyValue().vmName.toLowerCase().equals(name) : property.getPropertyValue().vmName.equals(name))) continue;
            return false;
        }
        File file = new File(FilePathResources.getTizenSDKDataVmsPath() + File.separator + name);
        return !file.exists();
    }

    public static boolean checkDuplicateTemplateName(String t, Platform platform) {
        boolean isWindows = false;
        if (OSUtil.isWin()) {
            isWindows = true;
            t = t.toLowerCase();
        }
        for (String templateName : DeviceTemplateUtil.getDeviceTemplateNameList(platform)) {
            if (!(isWindows ? templateName.toLowerCase().equals(t) : templateName.equals(t))) continue;
            return false;
        }
        return true;
    }

    public static Platform checkDuplicatePlatformImageName(String name) {
        for (Platform platform : PlatformList.getList()) {
            if (!platform.getName().equals(name)) continue;
            return platform;
        }
        return null;
    }

    public static boolean isAvailablePath(String path) {
        File partFile;
        return path == null || !(partFile = new File(path + ".part")).exists();
    }

    public static String getLocalIPAddress(int ecsPort) {
        if (loaclIPAddress == null) {
            try {
                Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
                if (interfaces != null) {
                    while (interfaces.hasMoreElements()) {
                        NetworkInterface current = interfaces.nextElement();
                        if (!current.isUp() || current.isLoopback() || current.isVirtual()) continue;
                        Enumeration<InetAddress> addresses = current.getInetAddresses();
                        while (addresses.hasMoreElements()) {
                            InetAddress current_addr = addresses.nextElement();
                            if (current_addr.isLoopbackAddress() || current_addr instanceof Inet6Address) continue;
                            loaclIPAddress = current_addr.getHostAddress();
                        }
                    }
                }
            }
            catch (SocketException e) {
                EMLogger.getLogger().warning(e.getMessage());
            }
        }
        return loaclIPAddress;
    }

    public static void FileCopy(File source, File dest) throws IOException {
        try (FileInputStream inputStream = new FileInputStream(source);
             FileOutputStream outputStream = new FileOutputStream(dest);
             BufferedInputStream bin = new BufferedInputStream(inputStream);
             BufferedOutputStream bout = new BufferedOutputStream(outputStream);){
            int bytesRead = 0;
            byte[] buffer = new byte[1024];
            while ((bytesRead = bin.read(buffer, 0, 1024)) != -1) {
                bout.write(buffer, 0, bytesRead);
            }
        }
    }

    public static ProcessResult runProcess(List<String> cmd) {
        return HelperClass.runProcess(cmd, null, true);
    }

    public static ProcessResult runProcess(List<String> cmd, boolean wait) {
        return HelperClass.runProcess(cmd, null, wait);
    }

    public static ProcessResult runProcess(List<String> cmd, File directory) {
        return HelperClass.runProcess(cmd, null, true);
    }

    public static ProcessResult runProcess(List<String> cmd, File directory, boolean wait) {
        ProcessResult result = null;
        ProcessBuilder pb = new ProcessBuilder(cmd);
        int exitValue = 0;
        Process process = null;
        String workingDirPath = null;
        if (directory == null) {
            workingDirPath = System.getProperty("user.dir");
        } else {
            workingDirPath = directory.getAbsolutePath();
            pb.directory(directory);
        }
        EMLogger.getLogger().log(Level.INFO, "Try to run external process: " + cmd);
        EMLogger.getLogger().log(Level.INFO, " -- Working dir : " + workingDirPath);
        try {
            process = pb.start();
            if (!wait) {
                return new ProcessResult(process);
            }
            List<String> stdOut = ProcessOutputReader.readStdOut(process, cmd.toString());
            List<String> stdErr = ProcessOutputReader.readStdErr(process, cmd.toString());
            exitValue = process.waitFor();
            result = new ProcessResult(true, exitValue);
            result.setStdOutMsg(stdOut);
            result.setStdErrMsg(stdErr);
        }
        catch (IOException e) {
            EMLogger.getLogger().warning("Run process fail. " + e.getMessage());
            result = new ProcessResult(false, -1);
            result.setStdErrMsg(Arrays.asList(e.getMessage()));
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            EMLogger.getLogger().info("Process end with interrupt. " + e.getMessage());
            result = new ProcessResult(false, -1);
            result.setStdErrMsg(Arrays.asList(e.getMessage()));
        }
        return result;
    }

    public static boolean pathEquals(String source, String target) {
        if (source == null && target == null) {
            return false;
        }
        if (source == null || target == null) {
            return false;
        }
        if (OSUtil.isWin()) {
            String path1 = source.replace("/", File.separator);
            String path2 = target.replace("/", File.separator);
            return path1.equals(path2);
        }
        return source.equals(target);
    }

    public static String getDefaultTemplateName(DeviceTemplateValue value, Platform platform) {
        String newName;
        String prefix = value.getProfile();
        prefix = prefix + "-";
        int count = 1;
        while (!HelperClass.checkDuplicateTemplateName(newName = prefix + Integer.toString(count++), platform)) {
        }
        return newName;
    }

    public static String getCloneTemplateName(DeviceTemplateValue value, Platform platform) {
        String newName;
        String prefix = value.getName().replaceAll("\\([0-9]*\\)$", "");
        prefix = prefix + "(";
        int count = 2;
        while (!HelperClass.checkDuplicateTemplateName(newName = prefix + Integer.toString(count++) + ")", platform)) {
        }
        return newName;
    }

    public static String getDefaultVMName(VMPropertyValue value) {
        StringBuilder sb = new StringBuilder();
        sb.append(value.getProfile().substring(0, 1).toLowerCase());
        if (!value.isStandardImage()) {
            sb.append("c");
        }
        sb.append("-");
        SimpleDateFormat formatter = new SimpleDateFormat("MMdd");
        Date currentTime = new Date();
        String timeStr = formatter.format(currentTime);
        sb.append(timeStr);
        sb.append("-");
        int count = 1;
        String prefix = sb.toString();
        StringBuilder vmName = null;
        do {
            vmName = new StringBuilder();
            vmName.append(prefix).append(Integer.toString(count++));
        } while (!HelperClass.checkDuplicateName(vmName.toString()));
        return vmName.toString();
    }

    public static String getMacAddress() {
        String newMacAddr;
        boolean isDuplicated = false;
        block0: do {
            newMacAddr = HelperClass.genetateRandomMacAddr();
            for (VMProperty prop : EmulatorManager.getVMKeeper().getProperties()) {
                if (!newMacAddr.equals(prop.getPropertyValue().getAdvancedOptionValue("netMac"))) continue;
                isDuplicated = true;
                continue block0;
            }
        } while (isDuplicated);
        return newMacAddr;
    }

    private static String genetateRandomMacAddr() {
        String[] MAC_CHAR = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "A", "B", "C", "D", "E", "F"};
        rd.nextInt(15);
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < 12; ++i) {
            sb.append(MAC_CHAR[rd.nextInt(15)]);
            if (i == 1) {
                int firstByteInt = Integer.parseInt(sb.toString(), 16);
                firstByteInt &= 0xFC;
                StringBuilder hex = new StringBuilder(Integer.toHexString(firstByteInt |= 2));
                if (hex.length() < 2) {
                    hex.insert(0, "0");
                }
                sb.replace(0, 2, hex.toString());
            }
            if (i <= 0 || i >= 11 || i % 2 != 1) continue;
            sb.append(":");
        }
        return sb.toString();
    }
}

