/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.emulator.manager.ui.control;

import java.util.ArrayList;
import java.util.List;
import javafx.scene.Node;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import org.tizen.emulator.manager.ui.control.ArrowLabel;
import org.tizen.emulator.manager.ui.control.StepLabel;

public class StepLabelBar {
    private int count = 0;
    private HBox hBox;
    private List<StepLabel> labels = new ArrayList<StepLabel>();
    private List<ArrowLabel> arrows = new ArrayList<ArrowLabel>();

    public StepLabelBar() {
        this.hBox = new HBox();
    }

    public int addStep() {
        StepLabel label = new StepLabel(++this.count);
        if (this.count > 1) {
            ArrowLabel a = new ArrowLabel();
            a.setState(ArrowLabel.STATE.NOR_NOR);
            this.arrows.add(a);
            this.hBox.getChildren().add((Object)a.getNode());
        }
        label.setState(StepLabel.STATE.NORMAL);
        this.labels.add(label);
        this.hBox.getChildren().add((Object)label.getNode());
        HBox.setHgrow((Node)label.getNode(), (Priority)Priority.ALWAYS);
        return this.count - 1;
    }

    public void setText(int index, String text) {
        if (index > this.labels.size()) {
            return;
        }
        this.labels.get(index).setText(text);
    }

    public void setButtonState(int index, StepLabel.STATE state) {
        if (index > this.labels.size()) {
            return;
        }
        this.labels.get(index).setState(state);
        if (index + 1 < this.labels.size()) {
            StepLabel.STATE nextState = this.labels.get(index + 1).getState();
            switch (state) {
                case NORMAL: {
                    if (nextState != StepLabel.STATE.NORMAL) break;
                    this.arrows.get(index).setState(ArrowLabel.STATE.NOR_NOR);
                    break;
                }
                case SELECT: {
                    if (nextState != StepLabel.STATE.NORMAL) break;
                    this.arrows.get(index).setState(ArrowLabel.STATE.SEL_NOR);
                    break;
                }
                case COMPLETE: {
                    if (nextState == StepLabel.STATE.COMPLETE) {
                        this.arrows.get(index).setState(ArrowLabel.STATE.COM_COM);
                        break;
                    }
                    if (nextState != StepLabel.STATE.SELECT) break;
                    this.arrows.get(index).setState(ArrowLabel.STATE.COM_SEL);
                    break;
                }
            }
        }
        if (index - 1 >= 0) {
            StepLabel.STATE prevState = this.labels.get(index - 1).getState();
            switch (state) {
                case NORMAL: {
                    if (prevState == StepLabel.STATE.NORMAL) {
                        this.arrows.get(index - 1).setState(ArrowLabel.STATE.NOR_NOR);
                        break;
                    }
                    if (prevState != StepLabel.STATE.SELECT) break;
                    this.arrows.get(index - 1).setState(ArrowLabel.STATE.SEL_NOR);
                    break;
                }
                case SELECT: {
                    if (prevState != StepLabel.STATE.COMPLETE) break;
                    this.arrows.get(index - 1).setState(ArrowLabel.STATE.COM_SEL);
                    break;
                }
                case COMPLETE: {
                    if (prevState != StepLabel.STATE.COMPLETE) break;
                    this.arrows.get(index - 1).setState(ArrowLabel.STATE.COM_COM);
                    break;
                }
            }
        }
    }

    public Node getNode() {
        return this.hBox;
    }
}

