/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.emulator.manager.ui.tabview.item;

import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import org.tizen.emulator.manager.ui.tabview.STATE;
import org.tizen.emulator.manager.ui.tabview.event.Event;
import org.tizen.emulator.manager.ui.tabview.event.EventType;
import org.tizen.emulator.manager.ui.tabview.item.ComboViewItem;
import org.tizen.emulator.manager.ui.tabview.item.TextViewField;
import org.tizen.emulator.manager.ui.tabview.item.ViewItem;

public class NetProxyViewItem
extends ViewItem {
    private VBox box;
    private ComboViewItem combo;
    private VBox proxySettingBox;
    private Proxy HTTP = new Proxy("HTTP");
    private Proxy HTTPS = new Proxy("HTTPS");
    private Proxy FTP = new Proxy("FTP");
    private Proxy SOCKS = new Proxy("SOCKS");
    private CheckBox checkUseHttp;

    public NetProxyViewItem() {
        this.baseView.removeStateLabel();
        this.box = new VBox();
        this.box.setAlignment(Pos.CENTER_LEFT);
        this.combo = new ComboViewItem();
        this.box.getChildren().add((Object)this.combo.getContent());
        this.makeProxySettingView();
        this.combo.addEventHandler(EventType.Selection, new org.tizen.emulator.manager.ui.tabview.event.EventHandler<Event>(){

            @Override
            public void handleEvent(Event event) {
                NetProxyViewItem.this.sendEvent(event);
            }
        });
        this.baseView.setPrefHeight(28.0);
        this.baseView.setViewItem((Node)this.box);
    }

    public void showSetting(boolean isShow) {
        if (isShow) {
            this.box.getChildren().add((Object)this.proxySettingBox);
            this.baseView.updateLayout();
        } else {
            this.box.getChildren().remove((Object)this.proxySettingBox);
            this.baseView.updateLayout();
        }
    }

    public boolean isUseHTTP() {
        return this.checkUseHttp.selectedProperty().get();
    }

    public void setCheckUseHTTP(boolean check) {
        this.checkUseHttp.selectedProperty().set(check);
        this.setUseHTTP();
    }

    private void setUseHTTP() {
        if (this.checkUseHttp.selectedProperty().get()) {
            this.HTTPS.clear();
            this.FTP.clear();
            this.SOCKS.clear();
            ((Node)this.proxySettingBox.getChildren().get(3)).setDisable(true);
            ((Node)this.proxySettingBox.getChildren().get(4)).setDisable(true);
            ((Node)this.proxySettingBox.getChildren().get(5)).setDisable(true);
        } else {
            ((Node)this.proxySettingBox.getChildren().get(3)).setDisable(false);
            ((Node)this.proxySettingBox.getChildren().get(4)).setDisable(false);
            ((Node)this.proxySettingBox.getChildren().get(5)).setDisable(false);
        }
    }

    public String getHttp() {
        return this.HTTP.getIp().getText();
    }

    public String getHttpPort() {
        return this.HTTP.getPort().getText();
    }

    public void setHttpProxy(String addr, String port) {
        this.HTTP.getIp().setText(addr);
        this.HTTP.getPort().setText(port);
    }

    public String getHttps() {
        return this.HTTPS.getIp().getText();
    }

    public String getHttpsPort() {
        return this.HTTPS.getPort().getText();
    }

    public void setHttpsProxy(String addr, String port) {
        this.HTTPS.getIp().setText(addr);
        this.HTTPS.getPort().setText(port);
    }

    public String getFtp() {
        return this.FTP.getIp().getText();
    }

    public String getFtpPort() {
        return this.FTP.getPort().getText();
    }

    public void setFtpProxy(String addr, String port) {
        this.FTP.getIp().setText(addr);
        this.FTP.getPort().setText(port);
    }

    public String getSocks() {
        return this.SOCKS.getIp().getText();
    }

    public String getSocksPort() {
        return this.SOCKS.getPort().getText();
    }

    public void setSocksProxy(String addr, String port) {
        this.SOCKS.getIp().setText(addr);
        this.SOCKS.getPort().setText(port);
    }

    @Override
    public String toString() {
        return this.combo.getSelectedItem();
    }

    public void addItem(String string, Object data) {
        this.combo.addItem(string, data);
    }

    public void selectItem(String data) {
        this.combo.selectItem(data);
    }

    @Override
    public void setState(STATE state, String msg) {
        if (this.combo != null) {
            this.combo.setState(state, msg);
        }
    }

    private void makeProxySettingView() {
        Label title = new Label();
        title.setText("Proxy Setting");
        title.setMinHeight(24.0);
        this.checkUseHttp = new CheckBox();
        this.checkUseHttp.setText("Use this proxy for all protocols");
        this.checkUseHttp.setMinHeight(30.0);
        this.proxySettingBox = new VBox();
        this.proxySettingBox.getChildren().add((Object)title);
        this.proxySettingBox.getChildren().add((Object)this.makeProxyBox(this.HTTP));
        this.proxySettingBox.getChildren().add((Object)this.checkUseHttp);
        this.proxySettingBox.getChildren().add((Object)this.makeProxyBox(this.HTTPS));
        this.proxySettingBox.getChildren().add((Object)this.makeProxyBox(this.FTP));
        this.proxySettingBox.getChildren().add((Object)this.makeProxyBox(this.SOCKS));
        VBox.setMargin((Node)title, (Insets)new Insets(5.0, 0.0, 0.0, 0.0));
        VBox.setMargin((Node)this.checkUseHttp, (Insets)new Insets(5.0, 0.0, 0.0, 55.0));
        this.proxySettingBox.setPrefHeight(130.0);
        this.addListener();
    }

    private HBox makeProxyBox(Proxy type) {
        HBox box = new HBox();
        VBox.setMargin((Node)box, (Insets)new Insets(5.0, 0.0, 0.0, 0.0));
        Label name = new Label();
        name.setText(type.getName() + ": ");
        name.setAlignment(Pos.CENTER_RIGHT);
        name.setPrefWidth(55.0);
        Label port = new Label();
        port.setText("Port: ");
        type.getIp().setPrefSize(120.0, 24.0);
        type.getPort().setMaxLen(5);
        type.getPort().setMatchStr("[0-9]");
        type.getPort().setPrefWidth(55.0);
        box.getChildren().add((Object)name);
        box.getChildren().add((Object)type.getIp());
        box.getChildren().add((Object)port);
        box.getChildren().add((Object)type.getPort());
        box.setMinHeight(24.0);
        box.setAlignment(Pos.CENTER_LEFT);
        HBox.setMargin((Node)port, (Insets)new Insets(0.0, 0.0, 0.0, 15.0));
        return box;
    }

    private void addListener() {
        this.checkUseHttp.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                NetProxyViewItem.this.setUseHTTP();
                Event viewEvent = new Event(EventType.Modify);
                NetProxyViewItem.this.sendEvent(viewEvent);
            }
        });
    }

    class Proxy {
        private String name;
        private TextField ip;
        private TextViewField port;

        Proxy(String name) {
            this.name = name;
            this.ip = new TextField();
            this.port = new TextViewField();
            this.ip.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

                public void changed(ObservableValue<? extends String> arg0, String arg1, String arg2) {
                    Event viewEvent = new Event(EventType.Modify);
                    NetProxyViewItem.this.sendEvent(viewEvent);
                }
            });
            this.port.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

                public void changed(ObservableValue<? extends String> arg0, String arg1, String arg2) {
                    Event viewEvent = new Event(EventType.Modify);
                    NetProxyViewItem.this.sendEvent(viewEvent);
                }
            });
        }

        public String getName() {
            return this.name;
        }

        public TextField getIp() {
            return this.ip;
        }

        public TextViewField getPort() {
            return this.port;
        }

        public void clear() {
            this.ip.setText("");
            this.port.setText("");
        }
    }
}

