/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.emulator.manager.concurrent.overseer;

import java.io.File;
import java.util.ArrayList;
import java.util.logging.Level;
import org.tizen.emulator.manager.concurrent.overseer.Job;
import org.tizen.emulator.manager.logging.EMLogger;
import org.tizen.emulator.manager.resources.FilePathResources;
import org.tizen.emulator.manager.tool.OSUtil;
import org.tizen.emulator.manager.vms.helper.HelperClass;
import org.tizen.emulator.manager.vms.helper.ProcessResult;

public class CheckVT
extends Job {
    private static final String HAX_CHECKER = OSUtil.isWin() ? "check-hax.exe" : "check-hax";
    private static final String ENABLE_HAX = "-enable-hax";
    private static final String ENABLE_KVM = "-enable-kvm";
    private static final String KVM_DEV_NODE = "/dev/kvm";
    private boolean isVTSupported = false;
    private boolean isNonUG = false;

    CheckVT() {
    }

    public static String getVTEnablingCommand() {
        if (OSUtil.isWin() || OSUtil.isMac()) {
            return ENABLE_HAX;
        }
        return ENABLE_KVM;
    }

    public static boolean isVTSupported() {
        return CheckVT.getInstance(CheckVT.class).isVTSupported;
    }

    public static boolean isNonUG() {
        return CheckVT.getInstance(CheckVT.class).isNonUG;
    }

    @Override
    public void work() {
        if (OSUtil.isWin() || OSUtil.isMac()) {
            ArrayList<String> cmd = new ArrayList<String>();
            cmd.add(FilePathResources.getEmulatorCheckToolPath() + File.separator + HAX_CHECKER);
            ProcessResult result = HelperClass.runProcess(cmd, new File(FilePathResources.getEmulatorCheckToolPath()));
            switch (result.getExitValue()) {
                case 0: {
                    this.isVTSupported = true;
                    break;
                }
                case 1: {
                    this.isVTSupported = true;
                    this.isNonUG = true;
                    break;
                }
            }
        } else if (OSUtil.isLinux() && new File(KVM_DEV_NODE).canRead()) {
            this.isVTSupported = true;
        }
        EMLogger.getLogger().log(Level.INFO, "Support HW virtualization: " + Boolean.toString(this.isVTSupported));
        EMLogger.getLogger().log(Level.INFO, "non-UG: " + Boolean.toString(this.isNonUG));
    }
}

