/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.emulator.manager.vms.monitor;

import java.io.IOException;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.tizen.emulator.manager.logging.EMLogger;
import org.tizen.emulator.manager.vms.ListChangeListener;
import org.tizen.emulator.manager.vms.VMKeeper;
import org.tizen.emulator.manager.vms.VMProperty;
import org.tizen.emulator.manager.vms.monitor.MonitoringThread;

public class VMAvailabilityMonitor
implements Runnable,
ListChangeListener<VMProperty> {
    private static VMAvailabilityMonitor instance;
    private final Queue<VMProperty> suspects = new ConcurrentLinkedQueue<VMProperty>();

    VMAvailabilityMonitor() throws IOException {
        VMKeeper.addListChangeListener(this);
    }

    public static synchronized void initialize() throws IOException {
        assert (instance == null);
        instance = new VMAvailabilityMonitor();
        MonitoringThread.newMonitoringThread(instance, "VMAvailabilityMonitor").start();
    }

    @Override
    public void elementAdded(VMProperty property) {
        this.checkAvailability(property);
        this.suspects.add(property);
    }

    @Override
    public void elementRemoved(VMProperty property) {
        this.suspects.remove(property);
    }

    @Override
    public void elementModified(VMProperty object) {
    }

    private void checkAvailability(VMProperty property) {
        if (property.getHealth() == VMProperty.Health.CORRUPTED) {
            return;
        }
        property.checkAvailability();
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void run() {
        while (true) lbl-1000:
        // 4 sources

        {
            for (VMProperty property : this.suspects) {
                this.checkAvailability(property);
            }
            try {
                Thread.sleep(1000L);
                ** continue;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                e.printStackTrace();
                EMLogger.printStackTrace(e);
                continue;
            }
            break;
        }
    }
}

