/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.emulator.manager.console;

import java.util.ArrayList;
import org.tizen.emulator.manager.console.Command;
import org.tizen.emulator.manager.console.Option;
import org.tizen.emulator.manager.console.resources.Messages;
import org.tizen.emulator.manager.console.resources.StringResources;
import org.tizen.emulator.manager.console.util.RemoteManagerCLI;

class RemoteCreate
extends Command {
    public RemoteCreate() {
        this.commandString = "remote-create";
        this.description = Messages.getString("ActionList.RemoteCreate.0");
        this.usage = Messages.getString("ActionList.RemoteCreate.1") + StringResources.NEW_LINE + Messages.getString("ActionList.RemoteCreate.2") + StringResources.NEW_LINE + Messages.getString("ActionList.RemoteCreate.3") + StringResources.NEW_LINE + Messages.getString("ActionList.RemoteCreate.4") + StringResources.NEW_LINE + Messages.getString("ActionList.RemoteCreate.5") + StringResources.NEW_LINE + Messages.getString("ActionList.RemoteCreate.6");
        this.optionList.add(new Option("n", "name", Messages.getString("ActionList.VMNameOption"), "", true, true));
        this.optionList.add(new Option("p", "custom-path", StringResources.DESC_CUSTOM_PATH, "", false, true));
        this.optionList.add(new Option("u", "user-account", StringResources.DESC_USER_ACCOUNT, "", true, true));
        this.optionList.add(new Option("e", "ip", StringResources.DESC_IP, "", true, true));
        this.optionList.add(new Option("l", "sdk-path-num", StringResources.DESC_SDK_PATH_NUM, "", false, true));
    }

    @Override
    public boolean process() {
        RemoteManagerCLI remoteManager = new RemoteManagerCLI();
        ArrayList<String> cmd = new ArrayList<String>();
        boolean isStandard = false;
        boolean isCustom = false;
        remoteManager.storeRemoteInfo(this.optionList);
        remoteManager.sshCmd(cmd);
        cmd.add("create");
        for (Option c : this.optionList) {
            switch (c.getShortName().charAt(0)) {
                case 'n': {
                    if (c.getCurrentValue().equals("")) break;
                    cmd.add("-n " + c.getCurrentValue());
                    break;
                }
                case 'b': {
                    if (c.getCurrentValue().equals("")) break;
                    cmd.add("-b " + c.getCurrentValue());
                    isStandard = true;
                    break;
                }
                case 'p': {
                    if (c.getCurrentValue().equals("")) break;
                    cmd.add("-p " + c.getCurrentValue());
                    isCustom = true;
                    break;
                }
            }
        }
        if (isStandard && isCustom) {
            System.out.println(Messages.getString("ActionList.CreateOptionError.0"));
            return false;
        }
        if (!isStandard && !isCustom) {
            System.out.println(Messages.getString("ActionList.CreateOptionError.1"));
            return false;
        }
        return remoteManager.runRemoteCmd(cmd);
    }
}

