/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.emulator.manager.vms.option;

import java.util.logging.Level;
import org.tizen.emulator.manager.EmulatorManager;
import org.tizen.emulator.manager.Messages;
import org.tizen.emulator.manager.logging.EMLogger;
import org.tizen.emulator.manager.network.NetworkUtil;
import org.tizen.emulator.manager.network.WindowsBridge;
import org.tizen.emulator.manager.resources.StringResources;
import org.tizen.emulator.manager.tool.OSUtil;
import org.tizen.emulator.manager.tool.SettingInfoFile;
import org.tizen.emulator.manager.vms.VMProperty;
import org.tizen.emulator.manager.vms.exception.VMLauncherException;
import org.tizen.emulator.manager.vms.exception.VMWorkerException;
import org.tizen.emulator.manager.vms.option.LaunchConfig;
import org.tizen.emulator.manager.vms.option.OPTION_KEY;
import org.tizen.emulator.manager.vms.option.Option;

public class NetworkOption
extends Option {
    private static final String NETDEV_OPTION = "-netdev";

    @Override
    public void getLaunchArgument(LaunchConfig config, VMProperty property) throws VMWorkerException {
        boolean isBridge = property.getPropertyValue().getAdvancedOptionValue("netConnectType").equals("Bridge");
        if (isBridge) {
            if (OSUtil.isWin()) {
                String tapName = property.getPropertyValue().getAdvancedOptionValue("netTapDevice");
                config.addQemuOption(NETDEV_OPTION, "tap,id=net0,ifname=" + tapName + ",script=no,downscript=no");
            } else {
                config.addQemuOption(NETDEV_OPTION, "tap,id=net0,script=/etc/emulator-ifup.sh,downscript=no");
            }
            config.addVariable(OPTION_KEY.VAR_MAC, this.getMacAddr(isBridge, property));
            config.addQemuOption("-device", "virtio-net-pci,netdev=net0,mac=" + NetworkOption.varForm(OPTION_KEY.VAR_MAC));
        } else {
            config.addQemuOption(NETDEV_OPTION, "user,id=net0");
            config.addQemuOption("-device", "virtio-net-pci,netdev=net0");
        }
        config.addKernelOption(this.getIP(isBridge, property));
        String hostIP = property.getPropertyValue().getAdvancedOptionValue("hostIp");
        if (hostIP == null || hostIP.isEmpty()) {
            hostIP = this.getDefaultHostIP(isBridge, property);
        }
        config.addKernelOption("host_ip", hostIP, OPTION_KEY.VAR_HOST_IP);
    }

    protected String getMacAddr(boolean isBridge, VMProperty property) {
        String macAddr;
        String string = macAddr = isBridge ? property.getPropertyValue().getAdvancedOptionValue("netMac") : SettingInfoFile.getMACaddr();
        if (macAddr.isEmpty()) {
            macAddr = "52:54:00:12:34:56";
            EMLogger.getLogger().log(Level.INFO, String.format("MAC set as default = %s", macAddr));
        }
        return macAddr;
    }

    protected String getIP(boolean isBridge, VMProperty prop) {
        StringBuilder sb = new StringBuilder();
        sb.append("ip=");
        if (isBridge) {
            String useDHCP = prop.getPropertyValue().getAdvancedSubOptionValue("netIpInfo", "useDHCP");
            if (this.checkOn(useDHCP)) {
                return "";
            }
        } else {
            return "";
        }
        sb.append(prop.getPropertyValue().getAdvancedSubOptionValue("netIpInfo", "ipAddr"));
        sb.append("::");
        sb.append(prop.getPropertyValue().getAdvancedSubOptionValue("netIpInfo", "gateway"));
        sb.append(":");
        sb.append(prop.getPropertyValue().getAdvancedSubOptionValue("netIpInfo", "subnet"));
        sb.append("::eth0:none:");
        sb.append(prop.getPropertyValue().getAdvancedOptionValue("netDns"));
        return sb.toString();
    }

    protected String getDefaultHostIP(boolean isBridge, VMProperty property) throws VMWorkerException {
        if (property.getPropertyValue().getAdvancedOption("hostIp") != null) {
            return property.getPropertyValue().getAdvancedOptionValue("hostIp");
        }
        String hostIp = "10.0.2.2";
        if (isBridge) {
            String bridgeIp = NetworkUtil.getBridgeIpAddress(property.getPropertyValue().getAdvancedOptionValue("netTapDevice"));
            hostIp = bridgeIp == null ? "" : bridgeIp;
        }
        return hostIp;
    }

    @Override
    public void checkArgument(VMProperty property) throws VMLauncherException {
        boolean isBridge = property.getPropertyValue().getAdvancedOptionValue("netConnectType").equals("Bridge");
        if (!isBridge) {
            return;
        }
        String tapName = property.getPropertyValue().getAdvancedOptionValue("netTapDevice");
        String guestIpAddr = property.getPropertyValue().getAdvancedSubOptionValue("netIpInfo", "ipAddr");
        String hostIpAddr = property.getPropertyValue().getAdvancedOptionValue("hostIp");
        if (!guestIpAddr.isEmpty() && hostIpAddr.equals(guestIpAddr)) {
            throw new VMLauncherException(Messages.getString("NetworkOption.IPDuplicated.0") + StringResources.NEW_LINE + Messages.getString("NetworkOption.IPDuplicated.1"));
        }
        if (OSUtil.isWin()) {
            if (!NetworkUtil.isTapExist(tapName)) {
                throw new VMLauncherException(Messages.getString("NetworkOption.TapDeviceError.0") + tapName + StringResources.NEW_LINE + Messages.getString("NetworkOption.TapDeviceError.1"));
            }
            if (this.isTapUsing(tapName)) {
                throw new VMLauncherException(Messages.getString("NetworkOption.TapDeviceError.2") + tapName + Messages.getString("NetworkOption.TapDeviceError.3") + StringResources.NEW_LINE + Messages.getString("NetworkOption.TapDeviceError.4"));
            }
            if (this.isIpAddrUsing(guestIpAddr)) {
                throw new VMLauncherException(Messages.getString("NetworkOption.IPError.0") + guestIpAddr + Messages.getString("NetworkOption.IPError.1") + Messages.getString("NetworkOption.IPError.2"));
            }
            if (!WindowsBridge.isWork()) {
                throw new VMLauncherException(Messages.getString("NetworkOption.WinBridgeError.0") + StringResources.NEW_LINE + Messages.getString("NetworkOption.WinBridgeError.1"));
            }
            try {
                if (!NetworkUtil.isTapInBridge(tapName)) {
                    throw new VMLauncherException(Messages.getString("NetworkOption.TapDeviceError.5") + StringResources.NEW_LINE + Messages.getString("NetworkOption.TapDeviceError.6") + StringResources.NEW_LINE + Messages.getString("NetworkOption.TapDeviceError.7"));
                }
            }
            catch (VMWorkerException e) {
                throw new VMLauncherException(e.getMessage());
            }
        }
    }

    protected boolean isTapUsing(String tapName) {
        boolean isUsing = false;
        for (VMProperty prop : EmulatorManager.getVMKeeper().getProperties()) {
            String name;
            if (!prop.isRunning() || !tapName.equals(name = prop.getPropertyValue().getAdvancedOptionValue("netTapDevice"))) continue;
            isUsing = true;
            break;
        }
        return isUsing;
    }

    protected boolean isIpAddrUsing(String ipAddr) {
        if (ipAddr.isEmpty()) {
            return false;
        }
        boolean isUsing = false;
        for (VMProperty prop : EmulatorManager.getVMKeeper().getProperties()) {
            String ip;
            if (!prop.isRunning() || !ipAddr.equals(ip = prop.getPropertyValue().getAdvancedSubOptionValue("netIpInfo", "ipAddr"))) continue;
            isUsing = true;
            break;
        }
        return isUsing;
    }
}

