/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.emulator.manager.vms.option;

import org.tizen.emulator.manager.tool.RemoteManager;
import org.tizen.emulator.manager.vms.VMProperty;
import org.tizen.emulator.manager.vms.exception.VMLauncherException;
import org.tizen.emulator.manager.vms.option.LaunchConfig;
import org.tizen.emulator.manager.vms.option.Option;

public class RemoteOption
extends Option {
    @Override
    public void getLaunchArgument(LaunchConfig config, VMProperty property) throws VMLauncherException {
        if (RemoteManager.getSpiceMode()) {
            config.addSkinOption("hb.ignore", "true");
        }
        if (RemoteOption.isRemoteMode(property)) {
            config.addQemuOption("-spice", "disable-ticketing");
            config.addQemuOption("-device", "virtio-serial-pci,id=virtio-serial0,max_ports=16,bus=pci.0");
            config.addQemuOption("-chardev", "spicevmc,id=vdagent,name=vdagent");
            config.addQemuOption("-device", "virtserialport,nr=1,bus=virtio-serial0.0,chardev=vdagent,name=com.redhat.spice.0");
            if (RemoteOption.isGreaterThanOrEqualTo(property.getPropertyValue().getImageVersion(), "2.3.2")) {
                config.addQemuOption("-display", "maru_remote_spice");
            }
        }
    }

    public static boolean isRemoteMode(VMProperty property) {
        return RemoteManager.getSpiceMode();
    }
}

