/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.emulator.manager.ui.controller;

import java.util.Map;
import java.util.WeakHashMap;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.scene.layout.HBox;
import org.tizen.emulator.manager.ui.controller.ButtonCreateEvent;
import org.tizen.emulator.manager.ui.dialog.CustomButtonBar;

public class ButtonBarController {
    private final ObservableList<ButtonType> buttons = FXCollections.observableArrayList();
    private final Map<ButtonType, Button> buttonNodes = new WeakHashMap<ButtonType, Button>();
    CustomButtonBar bBar;
    int buttonWidth;
    int buttonHeight;
    private EventHandler<ButtonCreateEvent> onButtonCreate = new EventHandler<ButtonCreateEvent>(){

        public void handle(ButtonCreateEvent arg0) {
        }
    };

    public HBox makeButtonBox(int buttonBoxHeight) {
        HBox hBox = new HBox();
        hBox.getStyleClass().add((Object)"button-bar");
        hBox.setPrefWidth(-1.0);
        hBox.setAlignment(Pos.CENTER_RIGHT);
        hBox.setPadding(new Insets(0.0, 20.0, 0.0, 0.0));
        this.bBar = new CustomButtonBar(hBox, buttonBoxHeight);
        this.bBar.getButtonPanel().setMaxWidth(Double.MAX_VALUE);
        this.bBar.setButtonMinWidth(this.buttonWidth);
        this.bBar.setButtonPrefHeight(this.buttonHeight);
        this.buttons.addListener((ListChangeListener)new ListChangeListener<ButtonType>(){

            public void onChanged(ListChangeListener.Change<? extends ButtonType> c) {
                while (c.next()) {
                    Button btn;
                    if (c.wasRemoved()) {
                        for (ButtonType cmd : c.getRemoved()) {
                            btn = (Button)ButtonBarController.this.buttonNodes.remove(cmd);
                            ButtonBarController.this.bBar.getButtons().remove((Object)btn);
                        }
                    }
                    if (!c.wasAdded()) continue;
                    for (ButtonType cmd : c.getAddedSubList()) {
                        if (ButtonBarController.this.buttonNodes.containsKey(cmd)) continue;
                        btn = ButtonBarController.this.createButton(cmd);
                        ButtonBarController.this.buttonNodes.put(cmd, btn);
                        ButtonBarController.this.bBar.getButtons().add((Object)btn);
                    }
                }
                ButtonBarController.this.updateButtons(ButtonBarController.this.bBar);
            }
        });
        return hBox;
    }

    public void addButton(ButtonType button) {
        this.buttons.add((Object)button);
    }

    public void removeButton(ButtonType button) {
        this.buttons.remove((Object)button);
    }

    public void setOnButtonCreate(EventHandler<ButtonCreateEvent> handler) {
        this.onButtonCreate = handler;
    }

    public Map<ButtonType, Button> getButtonNodes() {
        return this.buttonNodes;
    }

    public Button getButton(ButtonType type) {
        return this.buttonNodes.get(type);
    }

    public ButtonBarController(int buttonWidth, int buttonHeight) {
        this.buttonWidth = buttonWidth;
        this.buttonHeight = buttonHeight;
    }

    private Button createButton(ButtonType buttonType) {
        final Button button = new Button(buttonType.getText());
        ButtonBar.ButtonData buttonData = buttonType.getButtonData();
        CustomButtonBar.setButtonData((Node)button, (ButtonBar.ButtonData)buttonData);
        button.setCancelButton(buttonData.isCancelButton());
        this.onButtonCreate.handle((Event)new ButtonCreateEvent(button, buttonType));
        button.focusedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> arg0, Boolean arg1, Boolean focused) {
                if (focused.booleanValue()) {
                    button.setDefaultButton(true);
                }
            }
        });
        button.defaultButtonProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> arg0, Boolean arg1, Boolean isDefault) {
                if (isDefault.booleanValue()) {
                    for (Button node : ButtonBarController.this.buttonNodes.values()) {
                        if (node.equals(button)) continue;
                        node.setDefaultButton(false);
                    }
                }
            }
        });
        return button;
    }

    private void updateButtons(CustomButtonBar buttonBar) {
        buttonBar.layoutButtons();
    }

    public void selectDefaultButton() {
        for (Button button : this.buttonNodes.values()) {
            if (!button.isDefaultButton()) continue;
            button.fire();
            return;
        }
    }

    public void selectCancelButton() {
        for (Button button : this.buttonNodes.values()) {
            if (!button.isCancelButton()) continue;
            button.fire();
            return;
        }
    }
}

