/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.emulator.manager.console;

import java.util.ArrayList;
import org.tizen.emulator.manager.console.Command;
import org.tizen.emulator.manager.console.Option;
import org.tizen.emulator.manager.console.resources.Messages;
import org.tizen.emulator.manager.console.resources.StringResources;
import org.tizen.emulator.manager.console.util.RemoteManagerCLI;

class RemoteModify
extends Command {
    public RemoteModify() {
        this.commandString = "remote-modify";
        this.description = Messages.getString("ActionList.RemoteModify.0");
        this.usage = Messages.getString("ActionList.RemoteModify.1");
        this.optionList.add(new Option("n", "name", Messages.getString("ActionList.VMNameOption"), "", true, true));
        this.optionList.add(new Option("r", "resolution", Messages.getString("ActionList.ResolutionOption"), "", false, true));
        this.optionList.add(new Option("d", "dpi", Messages.getString("ActionList.DPIOption"), "", false, true));
        this.optionList.add(new Option("k", "skin", Messages.getString("ActionList.SkinOption"), "", false, true));
        this.optionList.add(new Option("s", "ram-size", Messages.getString("ActionList.RAMSizeOption"), "", false, true));
        this.optionList.add(new Option("f", "file-sharing-path", StringResources.DESC_FILESHAREPATH, "", false, true));
        this.optionList.add(new Option("v", "hw-virtualization", StringResources.DESC_VIRTUALIZATION, "", false, true));
        this.optionList.add(new Option("g", "hw-gl-acceleration", StringResources.DESC_GLACCELERATION, "", false, true));
        this.optionList.add(new Option("u", "user-account", StringResources.DESC_USER_ACCOUNT, "", true, true));
        this.optionList.add(new Option("e", "ip", StringResources.DESC_IP, "", true, true));
        this.optionList.add(new Option("l", "sdk-path-num", StringResources.DESC_SDK_PATH_NUM, "", false, true));
    }

    @Override
    public boolean process() {
        RemoteManagerCLI remoteManager = new RemoteManagerCLI();
        ArrayList<String> cmd = new ArrayList<String>();
        remoteManager.storeRemoteInfo(this.optionList);
        remoteManager.sshCmd(cmd);
        cmd.add("modify");
        for (Option c : this.optionList) {
            switch (c.getShortName().charAt(0)) {
                case 'n': {
                    if (c.getCurrentValue().equals("")) break;
                    cmd.add("-n " + c.getCurrentValue());
                    break;
                }
                case 'r': {
                    if (c.getCurrentValue().equals("")) break;
                    cmd.add("-r " + c.getCurrentValue());
                    break;
                }
                case 'd': {
                    if (c.getCurrentValue().equals("")) break;
                    cmd.add("-d " + c.getCurrentValue());
                    break;
                }
                case 'k': {
                    if (c.getCurrentValue().equals("")) break;
                    cmd.add("-k " + c.getCurrentValue());
                    break;
                }
                case 's': {
                    if (c.getCurrentValue().equals("")) break;
                    cmd.add("-s " + c.getCurrentValue());
                    break;
                }
                case 'f': {
                    if (c.getCurrentValue().equals("")) break;
                    cmd.add("-f " + c.getCurrentValue());
                    break;
                }
                case 'v': {
                    if (c.getCurrentValue().equals("")) break;
                    cmd.add("-v " + c.getCurrentValue());
                    break;
                }
                case 'g': {
                    if (c.getCurrentValue().equals("")) break;
                    cmd.add("-g " + c.getCurrentValue());
                    break;
                }
                case 'a': {
                    if (c.getCurrentValue().equals("")) break;
                    cmd.add("-a " + c.getCurrentValue());
                    break;
                }
            }
        }
        return remoteManager.runRemoteCmd(cmd);
    }
}

