/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.emulator.manager.ui.controller.create;

import javafx.beans.property.SimpleIntegerProperty;
import org.tizen.emulator.manager.platform.Version;
import org.tizen.emulator.manager.ui.item.TableCheckBoxItem;

public class PlatformItem
extends TableCheckBoxItem {
    private String profile;
    private String version;
    private String packageName;
    private Version platformVersion;

    public PlatformItem(String packageName, SimpleIntegerProperty checkCount) {
        super(checkCount);
        this.packageName = packageName;
        String[] arr = packageName.split("-");
        if (arr.length >= 3) {
            this.profile = arr[0];
            if (this.isNumber(arr[1])) {
                this.platformVersion = Version.createNew(arr[1]);
                this.version = this.platformVersion.getValue();
            } else {
                this.version = "";
                this.profile = arr[0] + "-" + arr[1];
            }
        } else {
            this.version = "";
            this.profile = "";
            packageName = "";
        }
    }

    public String getProfile() {
        return this.profile;
    }

    public void setProfile(String profile) {
        this.profile = profile;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public Version getPlatformVersion() {
        return this.platformVersion;
    }

    private boolean isNumber(String s) {
        if (s.isEmpty()) {
            return false;
        }
        for (int i = 0; i < s.length(); ++i) {
            if (s.charAt(i) == '.' || Character.digit(s.charAt(i), 10) >= 0) continue;
            return false;
        }
        return true;
    }
}

