/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.emulator.manager.ui.template.internal;

import java.util.List;
import org.tizen.emulator.manager.ui.template.Template;
import org.tizen.emulator.manager.ui.template.item.Group;
import org.tizen.emulator.manager.ui.template.item.Item;
import org.tizen.emulator.manager.ui.template.item.Option;
import org.tizen.emulator.manager.vms.xml.template.ItemList;

class Version1Template {
    private ItemList template;

    Version1Template() {
    }

    public Class<?> getXMLObjectType() {
        return ItemList.class;
    }

    public void setXMLObject(Object obj) {
        if (obj instanceof ItemList) {
            this.template = (ItemList)obj;
        }
    }

    public Object getXMLObject() {
        return this.template;
    }

    public Template convertTemplate() {
        Template vmTemplate = new Template();
        vmTemplate.setImageName(this.template.getImage());
        vmTemplate.setProfile(this.template.getProfile());
        vmTemplate.setVersion1ItemList(this.template);
        Group vmItemGroup = this.makeDefaultItemGroup(this.template.getPropertyList().getItem());
        vmTemplate.addGroup(vmItemGroup);
        vmItemGroup = new Group();
        vmItemGroup.setName("advanced");
        this.addItems(vmItemGroup, this.template.getPropertyList().getItem());
        this.addItems(vmItemGroup, this.template.getDeviceList().getItem());
        vmItemGroup.getItems().add(this.makeNetwork(this.template.getDeviceList().getItem()));
        vmTemplate.addGroup(vmItemGroup);
        return vmTemplate;
    }

    private Group makeDefaultItemGroup(List<org.tizen.emulator.manager.vms.xml.template.Item> itemList) {
        Group group = new Group();
        group.setName("default");
        group.getItems().add(this.makeVMName());
        group.getItems().add(this.makeProfile());
        group.getItems().add(this.makeBaseImage());
        Item deviceItem = new Item();
        deviceItem.setName("deviceTemplate");
        deviceItem.setTitle("Device");
        deviceItem.setType("treeRoot");
        for (org.tizen.emulator.manager.vms.xml.template.Item item : itemList) {
            if (!item.getName().equals("display") && !item.getName().equals("ramSize") && !item.getName().equals("processors")) continue;
            deviceItem.addSubItem(this.convertItem(item, false));
        }
        group.getItems().add(deviceItem);
        return group;
    }

    private void addItems(Group group, List<org.tizen.emulator.manager.vms.xml.template.Item> itemList) {
        boolean isExperimental = false;
        for (org.tizen.emulator.manager.vms.xml.template.Item item : itemList) {
            if (item.getName().equals("vmName") || item.getName().equals("baseImage") || item.getName().equals("display") || item.getName().equals("processors") || item.getName().equals("ramSize")) continue;
            if (item.getName().equals("experimental")) {
                isExperimental = true;
            }
            group.getItems().add(this.convertItem(item, isExperimental));
        }
    }

    private Item convertItem(org.tizen.emulator.manager.vms.xml.template.Item item, boolean isExperimental) {
        Item vmItem = new Item();
        vmItem.setName(item.getName());
        vmItem.setTitle(item.getTitle());
        vmItem.setType(item.getType());
        for (org.tizen.emulator.manager.vms.xml.template.Option option : item.getOption()) {
            Option vmOption = new Option();
            vmOption.setName(option.getName());
            vmOption.setValue(option.getValue());
            vmItem.getOptions().add(vmOption);
        }
        if (isExperimental) {
            Option vmOption = new Option();
            vmOption.setName("experimental");
            vmOption.setValue("true");
            vmItem.getOptions().add(vmOption);
        }
        for (org.tizen.emulator.manager.vms.xml.template.Item subItem : item.getItem()) {
            vmItem.addSubItem(this.convertItem(subItem, false));
        }
        return vmItem;
    }

    private Item makeNetwork(List<org.tizen.emulator.manager.vms.xml.template.Item> itemList) {
        Item netItem = new Item();
        netItem.setName("network");
        netItem.setTitle("Network");
        netItem.setType("label");
        for (org.tizen.emulator.manager.vms.xml.template.Item item : itemList) {
            if (!item.getName().equals("proxy") && !item.getName().equals("netConnectType") && !item.getName().equals("netTapDevice") && !item.getName().equals("netIpInfo") && !item.getName().equals("netDns") && !item.getName().equals("netMac")) continue;
            netItem.getSubItems().add(this.convertItem(item, false));
        }
        return netItem;
    }

    private Item makeVMName() {
        Item vmItem = new Item();
        vmItem.setName("name");
        vmItem.setTitle("VM Name");
        vmItem.setType("textInput");
        return vmItem;
    }

    private Item makeProfile() {
        Item vmItem = new Item();
        vmItem.setName("profile");
        vmItem.setTitle("Profile");
        return vmItem;
    }

    private Item makeBaseImage() {
        Item vmItem = new Item();
        vmItem.setName("baseImage");
        vmItem.setTitle("Base Image");
        return vmItem;
    }
}

