/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.emulator.manager.ui.controller.create;

import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import org.tizen.emulator.manager.platform.Platform;
import org.tizen.emulator.manager.platform.custom.CustomPlatform;
import org.tizen.emulator.manager.ui.controller.vms.ROW_STATE;
import org.tizen.emulator.manager.ui.resources.ImageKind;

public class PlatformTreeData {
    private final String name;
    private final boolean isCustom;
    private final String profile;
    private final ImageKind icon;
    private final ImageKind selectedIcon;
    private final ImageKind overIcon;
    private final BooleanProperty expandedProperty;
    private final boolean isRoot;
    private final Platform platform;
    private final SimpleObjectProperty<ROW_STATE> state = new SimpleObjectProperty();

    public PlatformTreeData(Platform platform, BooleanProperty expandedProperty) {
        this.platform = platform;
        this.expandedProperty = expandedProperty;
        this.isRoot = expandedProperty != null;
        this.name = platform.getName();
        this.profile = platform.getProfile().getName();
        this.isCustom = platform instanceof CustomPlatform;
        String profile = platform.getProfile().getName();
        if (profile.equals("mobile")) {
            this.icon = ImageKind.ICON_TYPE_MOBILE;
            this.selectedIcon = ImageKind.ICON_TYPE_MOBILE_SEL;
            this.overIcon = ImageKind.ICON_TYPE_MOBILE_OVER;
        } else if (profile.equals("wearable")) {
            this.icon = ImageKind.ICON_TYPE_WEARABLE;
            this.selectedIcon = ImageKind.ICON_TYPE_WEARABLE_SEL;
            this.overIcon = ImageKind.ICON_TYPE_WEARABLE_OVER;
        } else {
            this.icon = ImageKind.ICON_TYPE_TV;
            this.selectedIcon = ImageKind.ICON_TYPE_TV_SEL;
            this.overIcon = ImageKind.ICON_TYPE_TV_OVER;
        }
        this.state.set((Object)ROW_STATE.NORMAL);
    }

    public PlatformTreeData(Platform platform) {
        this(platform, null);
    }

    public String getProfile() {
        return this.profile;
    }

    public String getName() {
        return this.name;
    }

    public ImageKind getIcon() {
        return this.icon;
    }

    public ImageKind getSelectedIcon() {
        return this.selectedIcon;
    }

    public ImageKind getOverIcon() {
        return this.overIcon;
    }

    public SimpleObjectProperty<ROW_STATE> getState() {
        return this.state;
    }

    public boolean isCustom() {
        return this.isCustom;
    }

    public Platform getPlatform() {
        return this.platform;
    }

    public BooleanProperty expandedProperty() {
        return this.expandedProperty;
    }

    public boolean isRoot() {
        return this.isRoot;
    }
}

