/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.emulator.manager.ui.item;

import java.util.List;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.ScrollPane;
import javafx.scene.layout.Pane;
import javafx.scene.layout.VBox;
import org.tizen.emulator.manager.platform.Platform;
import org.tizen.emulator.manager.ui.controller.create.VMDialogData;
import org.tizen.emulator.manager.ui.controller.create.VMDialogPage;
import org.tizen.emulator.manager.ui.item.PlatformDisplayData;
import org.tizen.emulator.manager.ui.item.VMValue;
import org.tizen.emulator.manager.ui.tabview.MODE;
import org.tizen.emulator.manager.ui.tabview.controller.ViewItemController;

public class DetailPropertyView
implements VMDialogPage {
    private ScrollPane scroll;
    private final VBox pane = new VBox();

    public DetailPropertyView() {
        this.pane.setPadding(new Insets(25.0, 19.0, 25.0, 30.0));
        this.pane.setPrefSize(654.0, 620.0);
        this.pane.setStyle("-fx-background-color: white");
        this.scroll = new ScrollPane();
        this.scroll.setPrefSize(654.0, 620.0);
        this.scroll.setContent((Node)this.pane);
        this.scroll.setHbarPolicy(ScrollPane.ScrollBarPolicy.NEVER);
        this.scroll.setFitToWidth(true);
        this.scroll.setVbarPolicy(ScrollPane.ScrollBarPolicy.AS_NEEDED);
    }

    @Override
    public void onPageShow(VMDialogData data, SimpleBooleanProperty isInvalid) {
        Platform platform = data.getPlatform();
        if (platform == null) {
            return;
        }
        PlatformDisplayData platformData = PlatformDisplayData.getData(platform);
        List<ViewItemController> items = platformData.getDetailItems();
        VMValue newValue = new VMValue(data.getVmValue());
        for (ViewItemController i : items) {
            i.setMode(MODE.DETAIL);
            i.setIntializeValue(newValue);
            i.getViewItem().setPrefWidth(500.0);
            Pane viewNode = i.getViewItem().getContent();
            this.pane.getChildren().add((Object)viewNode);
            VBox.setMargin((Node)viewNode, (Insets)new Insets(5.0, 0.0, 5.0, 0.0));
        }
    }

    @Override
    public void setData(VMDialogData vmDialogData) {
    }

    @Override
    public Node getNode() {
        return this.scroll;
    }

    @Override
    public String getTitle() {
        return "Properties";
    }

    @Override
    public String getDescription() {
        return "The emulator properties";
    }

    @Override
    public boolean onPageHide(VMDialogData vmDialogData) {
        return true;
    }
}

