/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.emulator.manager.ui.devicetemplate.controller;

import org.tizen.emulator.manager.logging.EMLogger;
import org.tizen.emulator.manager.ui.devicetemplate.item.DisplaySizeViewItem;
import org.tizen.emulator.manager.ui.tabview.PropertyValue;
import org.tizen.emulator.manager.ui.tabview.controller.ViewItemController;
import org.tizen.emulator.manager.ui.tabview.event.Event;
import org.tizen.emulator.manager.ui.tabview.item.TextViewItem;
import org.tizen.emulator.manager.ui.tabview.item.ViewItem;
import org.tizen.emulator.manager.ui.template.item.Item;

public class DisplaySizeViewController
extends ViewItemController {
    static final int TEXT_WIDTH = 76;
    Double size;
    private DisplaySizeViewItem textView;

    public DisplaySizeViewController(Item item) {
        super(item);
    }

    @Override
    public void makeViewItem() {
        this.setViewItem(new TextViewItem());
    }

    @Override
    public ViewItem getViewItem() {
        return this.textView;
    }

    @Override
    public void setViewItem(ViewItem item) {
        this.textView = item instanceof DisplaySizeViewItem ? (DisplaySizeViewItem)item : new DisplaySizeViewItem();
        this.textView.setTitle(this.getTitle());
        this.textView.setTextWidth(76.0);
    }

    @Override
    public void setIntializeValue(PropertyValue value) {
        this.size = value.getDoubleValue(this.getName());
        if (this.size != null) {
            this.textView.setText(String.valueOf(this.size));
        }
    }

    @Override
    public void setPropertyValue(PropertyValue value) {
        try {
            this.size = Double.parseDouble(this.textView.getText());
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
            EMLogger.printStackTrace(e);
        }
        value.setDoubleValue(this.getName(), this.size);
    }

    @Override
    public void checkValid() {
    }

    @Override
    protected void onChangedValue(Event event) {
    }
}

