/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.emulator.manager.devices;

import java.util.ArrayList;
import java.util.List;
import org.tizen.emulator.manager.devices.SubDeviceItem;
import org.tizen.emulator.manager.devices.SubDeviceValue;

public class SubDevice {
    private String name = "";
    private List<SubDeviceItem> items = new ArrayList<SubDeviceItem>();
    private List<SubDeviceValue> values = new ArrayList<SubDeviceValue>();

    public SubDevice() {
    }

    public SubDevice(String name) {
        if (name != null) {
            this.name = name;
        }
    }

    public SubDevice(SubDevice value) {
        this.setName(value.name);
        for (SubDeviceItem subItem : value.getItems()) {
            this.items.add(new SubDeviceItem(subItem));
        }
        for (SubDeviceValue subValue : value.getValues()) {
            this.values.add(new SubDeviceValue(subValue));
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<SubDeviceItem> getItems() {
        return this.items;
    }

    public void setItems(List<SubDeviceItem> items) {
        this.items = items;
    }

    public void addSubDeviceItem(SubDeviceItem item) {
        if (item == null) {
            return;
        }
        this.items.add(item);
    }

    public void addSubDeviceItem(String id, boolean isSupport) {
        if (id == null) {
            return;
        }
        SubDeviceItem item = new SubDeviceItem(id);
        item.setSupport(isSupport);
        this.items.add(item);
    }

    public void updateSubDeviceItem(String id, boolean isSupport) {
        SubDeviceItem item = this.findSubDeviceItem(id);
        if (item == null) {
            this.addSubDeviceItem(id, isSupport);
        } else {
            item.setSupport(isSupport);
        }
    }

    private SubDeviceItem findSubDeviceItem(String id) {
        for (SubDeviceItem item : this.items) {
            if (!item.getId().equals(id)) continue;
            return item;
        }
        return null;
    }

    public List<SubDeviceValue> getValues() {
        return this.values;
    }

    public void setValues(List<SubDeviceValue> values) {
        this.values = values;
    }

    public void addSubDeviceValue(SubDeviceValue value) {
        if (value == null) {
            return;
        }
        this.values.add(value);
    }

    public void addSubDeviceValue(String name, String value) {
        if (name == null) {
            return;
        }
        SubDeviceValue item = new SubDeviceValue(name, value);
        this.values.add(item);
    }

    public void updateSubDeviceValue(String name, String value) {
        SubDeviceValue subDeviceValue = this.findSubDeviceValue(name);
        if (subDeviceValue == null) {
            this.addSubDeviceValue(name, value);
        } else {
            subDeviceValue.setValue(value);
        }
    }

    private SubDeviceValue findSubDeviceValue(String name) {
        for (SubDeviceValue value : this.values) {
            if (!value.getName().equals(name)) continue;
            return value;
        }
        return null;
    }

    public boolean equals(Object obj) {
        boolean equals;
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof SubDevice)) {
            return false;
        }
        SubDevice destDevice = (SubDevice)obj;
        if (!destDevice.name.equals(this.name)) {
            return false;
        }
        for (SubDeviceItem item : this.items) {
            equals = false;
            for (SubDeviceItem destItem : destDevice.getItems()) {
                if (!item.equals(destItem)) continue;
                equals = true;
                break;
            }
            if (equals) continue;
            return false;
        }
        for (SubDeviceValue subDeviceValue : this.values) {
            equals = false;
            for (SubDeviceValue destValue : destDevice.getValues()) {
                if (!subDeviceValue.equals(destValue)) continue;
                equals = true;
                break;
            }
            if (equals) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return 100;
    }
}

