/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.emulator.manager.resources;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.tizen.emulator.manager.logging.EMLogger;
import org.tizen.emulator.manager.platform.VersionList;
import org.tizen.emulator.manager.resources.InternalFindSDKPath;
import org.tizen.emulator.manager.tool.OSUtil;
import org.tizen.emulator.manager.vms.exception.InitializationException;

public class FilePathResources {
    private static final String EMULATOR_SUFFIX = File.separator + "emulator";
    private static final String PLATFORMS_SUFFIX = File.separator + "platforms";
    private static final String COMMON_SUFFIX = File.separator + "common";
    private static final String PLATFORM_PREFIX = File.separator + "tizen-";
    private static final String EM_IMAGES_SUFFIX = File.separator + "emulator-images";
    private static final String EM_RESOURCES_SUFFIX = File.separator + "emulator-resources";
    private static final String SKINS_SUFFIX = File.separator + "skins";
    private static final String TEMPLATE_SUFFIX = File.separator + "template";
    private static final String PLUGINS_SUFFIX = File.separator + "plugins";
    private static final String DATA_SUFFIX = File.separator + "data";
    private static final String BIOS_SUFFIX = File.separator + "bios";
    private static final String KERNEL_SUFFIX = File.separator + "kernel";
    private static final String TOOLS_SUFFIX = File.separator + "tools";
    private static final String BIN_SUFFIX = File.separator + "bin";
    private static final String ETC_SUFFIX = File.separator + "etc";
    private static final String REMOTE_SUFFIX = File.separator + "remote";
    private static final String IMAGES_SUFFIX = File.separator + "images";
    private static final String DEVICES_SUFFIX = File.separator + "devices";
    private static final String UI_SUFFIX = File.separator + "ui";
    private static final String STORAGES_SUFFIX = File.separator + "storages";
    private static final String SDCARD_SUFFIX = File.separator + "sdcard";
    private static final String SWAP_SUFFIX = File.separator + "swap";
    private static final String VMS_SUFFIX = File.separator + "vms";
    private static final String LOGS_SUFFIX = File.separator + "logs";
    private static final String DEVCON_SUFFIX = File.separator + "devcon.exe";
    private static final String SDB_SUFFIX = File.separator + "sdb" + (OSUtil.isWin() ? ".exe" : "");
    private static final String CHECK_NET_SUFFIX = File.separator + "check-net" + (OSUtil.isWin() ? ".exe" : "");
    private static final String QEMU_IMG_SUFFIX = File.separator + "qemu-img";
    private static final String LAUNCH_CONF_SUFFIX = File.separator + "vm_launch.conf";
    private static final String UTILS_SUFFIX = File.separator + "library";
    private static final String PACKAGE_MANAGER_SUFFIX = File.separator + "package-manager";
    private static final String INITIALISE_PATH_FAIL_REASON = "Failed to initalize file path resources because already initilized.";
    private static String sdkPath;
    private static String jdkPath;
    private static String platformsPath;
    private static String toolEmulatorPath;
    private static String sdbPath;
    private static String checkNetPath;
    private static String devConPath;
    private static String toolEmulatorBinPath;
    private static String toolEmulatorEtcPath;
    private static String toolEmulatorRemotePath;
    private static String toolEmulatorDevicePath;
    private static String toolEmulatorDataPath;
    private static String toolEmulatorSDCardPath;
    private static String toolEmulatorSwapPath;
    private static String toolEmulatorImagesPath;
    private static String platformSkinsPath;
    private static String platformTemplatePath;
    private static String platformPluginsPath;
    private static String platformImagesPath;
    private static String platformDeviceTemplatePath;
    private static String platformDeviceTemplateUIPath;
    private static String platformCommonPath;
    private static String sdkDataPath;
    private static String sdkDataEmulatorPath;
    private static String sdkDataVmsPath;
    private static String sdkDataDevicePath;
    private static String sdkDataDeviceCommonPath;
    private static String sdkDataSDcardPath;
    private static boolean isInitialized;

    private static void checkInitialize() throws InitializationException {
        if (!isInitialized) {
            throw new InitializationException();
        }
    }

    public static void initialize() throws IllegalStateException, IOException {
        if (isInitialized) {
            throw new IllegalStateException(INITIALISE_PATH_FAIL_REASON);
        }
        Path infoFile = null;
        if (System.getProperty("develop") != null && Files.notExists(infoFile = Paths.get(System.getProperty("user.home") + File.separator + "tizen-studio" + File.separator + "sdk.info", new String[0]), new LinkOption[0])) {
            infoFile = Paths.get("C:\\" + File.separator + "tizen-studio" + File.separator + "sdk.info", new String[0]);
        }
        FilePathResources.initialize(infoFile != null ? infoFile.getParent().toString() : null);
    }

    public static void initialize(String dir) throws IllegalStateException, IOException {
        if (isInitialized) {
            throw new IllegalStateException(INITIALISE_PATH_FAIL_REASON);
        }
        InternalFindSDKPath finder = new InternalFindSDKPath();
        finder.findSDKPath(dir);
        sdkDataPath = finder.getSDKDataPath();
        sdkPath = finder.getSDKPath();
        jdkPath = finder.getJdkPath();
        FilePathResources.initialize(sdkPath, sdkDataPath);
    }

    private static void initializeJavaPath() {
        File jdk;
        if (jdkPath == null) {
            jdkPath = Paths.get(sdkPath, "jdk").toAbsolutePath().toString();
        }
        jdkPath = !(jdk = new File(jdkPath)).exists() ? "java" : (OSUtil.isMac() ? Paths.get(jdkPath, "Contents", "Home", "bin", "java").toAbsolutePath().toString() : Paths.get(jdkPath, "bin", "java").toAbsolutePath().toString());
    }

    public static void initialize(String sdkDir, String sdkDataDir) throws IllegalStateException, IOException {
        if (isInitialized) {
            throw new IllegalStateException(INITIALISE_PATH_FAIL_REASON);
        }
        if (sdkDir == null || sdkDataDir == null) {
            throw new IOException("");
        }
        sdkPath = sdkDir;
        if (sdkPath.isEmpty()) {
            throw new IOException("Failed to get tizen-sdk-data path");
        }
        FilePathResources.initializeJavaPath();
        sdkDataPath = sdkDataDir;
        if (sdkDataPath.isEmpty()) {
            throw new IOException("Failed to get tizen-sdk path");
        }
        FilePathResources.intenalInitialize();
    }

    private static void intenalInitialize() {
        try {
            toolEmulatorPath = new File(sdkPath + TOOLS_SUFFIX + EMULATOR_SUFFIX).getCanonicalPath();
        }
        catch (IOException e) {
            toolEmulatorPath = sdkPath + TOOLS_SUFFIX + EMULATOR_SUFFIX;
        }
        platformsPath = sdkPath + PLATFORMS_SUFFIX;
        platformImagesPath = EM_IMAGES_SUFFIX;
        platformSkinsPath = EM_RESOURCES_SUFFIX + SKINS_SUFFIX;
        platformTemplatePath = EM_RESOURCES_SUFFIX + TEMPLATE_SUFFIX;
        platformPluginsPath = EM_RESOURCES_SUFFIX + PLUGINS_SUFFIX;
        platformDeviceTemplatePath = EM_RESOURCES_SUFFIX + DEVICES_SUFFIX;
        platformDeviceTemplateUIPath = EM_RESOURCES_SUFFIX + DEVICES_SUFFIX + UI_SUFFIX;
        platformCommonPath = platformsPath + COMMON_SUFFIX;
        sdbPath = sdkPath + TOOLS_SUFFIX + SDB_SUFFIX;
        toolEmulatorBinPath = toolEmulatorPath + BIN_SUFFIX;
        toolEmulatorEtcPath = toolEmulatorPath + ETC_SUFFIX;
        toolEmulatorRemotePath = toolEmulatorPath + REMOTE_SUFFIX;
        toolEmulatorDevicePath = toolEmulatorPath + DEVICES_SUFFIX;
        toolEmulatorDataPath = toolEmulatorPath + DATA_SUFFIX;
        toolEmulatorSDCardPath = toolEmulatorPath + STORAGES_SUFFIX + SDCARD_SUFFIX;
        toolEmulatorSwapPath = toolEmulatorPath + STORAGES_SUFFIX + SWAP_SUFFIX;
        toolEmulatorImagesPath = toolEmulatorPath + IMAGES_SUFFIX;
        checkNetPath = toolEmulatorBinPath + CHECK_NET_SUFFIX;
        devConPath = toolEmulatorBinPath + DEVCON_SUFFIX;
        sdkDataEmulatorPath = sdkDataPath + EMULATOR_SUFFIX;
        sdkDataSDcardPath = sdkDataEmulatorPath + SDCARD_SUFFIX;
        sdkDataVmsPath = sdkDataEmulatorPath + VMS_SUFFIX;
        File sdkDataVmsFodler = new File(sdkDataVmsPath);
        if (!sdkDataVmsFodler.exists() && !sdkDataVmsFodler.mkdirs()) {
            EMLogger.getLogger().warning("Failed to create directory " + sdkDataVmsFodler.getAbsolutePath());
        }
        sdkDataDevicePath = sdkDataEmulatorPath + DEVICES_SUFFIX;
        sdkDataDeviceCommonPath = sdkDataEmulatorPath + DEVICES_SUFFIX + COMMON_SUFFIX;
        FilePathResources.printSDKPathToLogFile();
        isInitialized = true;
    }

    private static void printSDKPathToLogFile() {
        EMLogger.log("Tizen SDK path: " + sdkPath);
        EMLogger.log("Tizen SDK data path: " + sdkDataPath);
    }

    private FilePathResources() {
    }

    public static String getTizenSDKPath() {
        FilePathResources.checkInitialize();
        return sdkPath;
    }

    public static String getSdbPath() {
        FilePathResources.checkInitialize();
        return sdbPath;
    }

    public static String getCheckNetPath() {
        FilePathResources.checkInitialize();
        return checkNetPath;
    }

    public static String getDevconPath() {
        FilePathResources.checkInitialize();
        return devConPath;
    }

    public static String getPlatformsPath() {
        FilePathResources.checkInitialize();
        return platformsPath;
    }

    public static String getToolEmulatorPath() {
        FilePathResources.checkInitialize();
        return toolEmulatorPath;
    }

    public static String getToolEmulatorBinPath() {
        FilePathResources.checkInitialize();
        return toolEmulatorBinPath;
    }

    public static String getToolEmulatorEtcPath() {
        FilePathResources.checkInitialize();
        return toolEmulatorEtcPath;
    }

    public static String getToolEmulatorRemotePath() {
        FilePathResources.checkInitialize();
        return toolEmulatorRemotePath;
    }

    public static String getToolEmulatorDevicePath() {
        FilePathResources.checkInitialize();
        return toolEmulatorDevicePath;
    }

    public static String getToolEmulatorDataPath() {
        FilePathResources.checkInitialize();
        return toolEmulatorDataPath;
    }

    public static String getToolEmulatorSDCardPath() {
        FilePathResources.checkInitialize();
        return toolEmulatorSDCardPath;
    }

    public static String getToolEmulatorSwapImagePath() {
        FilePathResources.checkInitialize();
        return toolEmulatorSwapPath;
    }

    public static String getToolEmulatorImagesPath() {
        FilePathResources.checkInitialize();
        return toolEmulatorImagesPath;
    }

    public static String getEmulatorCheckToolPath() {
        FilePathResources.checkInitialize();
        return FilePathResources.getToolEmulatorBinPath();
    }

    public static String getEmulatorQemuImgPath() {
        FilePathResources.checkInitialize();
        return FilePathResources.getEmulatorCheckToolPath() + QEMU_IMG_SUFFIX;
    }

    public static String getTizenSDKDataPath() {
        FilePathResources.checkInitialize();
        return sdkDataPath;
    }

    public static String getJavaPath() {
        FilePathResources.checkInitialize();
        return jdkPath;
    }

    public static String getTizenSDKDataEmulatorPath() {
        FilePathResources.checkInitialize();
        return sdkDataEmulatorPath;
    }

    public static String getTizenSDKDataVmsPath() {
        FilePathResources.checkInitialize();
        return sdkDataVmsPath;
    }

    public static String getTizenSDKDataDevicePath() {
        FilePathResources.checkInitialize();
        return sdkDataDevicePath;
    }

    public static String getTizenSDKDataDeviceCommonPath() {
        FilePathResources.checkInitialize();
        return sdkDataDeviceCommonPath;
    }

    public static String getVirtualTargetPath(String vmName) {
        FilePathResources.checkInitialize();
        return FilePathResources.getTizenSDKDataVmsPath() + File.separator + vmName;
    }

    public static String getVirtualTargetLaunchConfPath(String vmName) {
        FilePathResources.checkInitialize();
        return FilePathResources.getVirtualTargetPath(vmName) + LAUNCH_CONF_SUFFIX;
    }

    public static String getVirtualTargetLogPath(String vmName) {
        FilePathResources.checkInitialize();
        return FilePathResources.getVirtualTargetPath(vmName) + LOGS_SUFFIX;
    }

    public static String getEmulatorLogPath(String vmName) {
        FilePathResources.checkInitialize();
        return FilePathResources.getVirtualTargetLogPath(vmName) + File.separator + "emulator.log";
    }

    public static String getEmulatorKLogPath(String vmName) {
        FilePathResources.checkInitialize();
        return FilePathResources.getVirtualTargetLogPath(vmName) + File.separator + "emulator.klog";
    }

    public static String getEmulatorManagerLogPath() {
        FilePathResources.checkInitialize();
        return FilePathResources.getTizenSDKDataVmsPath() + File.separator + "emulator-manager.log";
    }

    public static String getEmulatorManagerCLILogPath() {
        FilePathResources.checkInitialize();
        return FilePathResources.getTizenSDKDataVmsPath() + File.separator + "emulator-manager-cli.log";
    }

    public static String getBaseSDCardPath() {
        FilePathResources.checkInitialize();
        return sdkDataSDcardPath;
    }

    public static String getPlatformEmulatorPath(String platformVersion) {
        String emulatorPath;
        FilePathResources.checkInitialize();
        if (platformVersion == null || platformVersion.isEmpty()) {
            platformVersion = VersionList.getLastest();
        }
        try {
            emulatorPath = new File(platformsPath + PLATFORM_PREFIX + platformVersion + COMMON_SUFFIX + EMULATOR_SUFFIX).getCanonicalPath();
        }
        catch (IOException e) {
            emulatorPath = platformsPath + PLATFORM_PREFIX + platformVersion + COMMON_SUFFIX + EMULATOR_SUFFIX;
        }
        return emulatorPath;
    }

    public static String getEmulatorBinSuffix() {
        FilePathResources.checkInitialize();
        return BIN_SUFFIX;
    }

    public static String getEmulatorDataSuffix() {
        FilePathResources.checkInitialize();
        return DATA_SUFFIX;
    }

    public static String getEmulatorKernelSuffix() {
        FilePathResources.checkInitialize();
        return DATA_SUFFIX + KERNEL_SUFFIX;
    }

    public static String getEmulatorBiosSuffix() {
        FilePathResources.checkInitialize();
        return DATA_SUFFIX + BIOS_SUFFIX;
    }

    public static String getPlatformResourcesSuffix() {
        FilePathResources.checkInitialize();
        return EM_RESOURCES_SUFFIX;
    }

    public static String getPlatformSkinsSuffix() {
        FilePathResources.checkInitialize();
        return platformSkinsPath;
    }

    public static String getPlatformTemplateSuffix() {
        FilePathResources.checkInitialize();
        return platformTemplatePath;
    }

    public static String getPlatformDeviceTemplateSuffix() {
        FilePathResources.checkInitialize();
        return platformDeviceTemplatePath;
    }

    public static String getPlatformDeviceTemplateUISuffix() {
        FilePathResources.checkInitialize();
        return platformDeviceTemplateUIPath;
    }

    public static String getPlatformPluginsSuffix() {
        FilePathResources.checkInitialize();
        return platformPluginsPath;
    }

    public static String getPlatformImagesSuffix() {
        FilePathResources.checkInitialize();
        return platformImagesPath;
    }

    public static String getFileExtention(String path) {
        String[] arr;
        FilePathResources.checkInitialize();
        if (path != null && (arr = path.split("\\.")).length > 1) {
            return arr[arr.length - 1];
        }
        return "";
    }

    public static String getPlatformCommonPath() {
        FilePathResources.checkInitialize();
        return platformCommonPath;
    }

    public static String getTizenSDKUtilPath() {
        FilePathResources.checkInitialize();
        return sdkPath + UTILS_SUFFIX;
    }

    public static String getTizenSDKPackageManagerPath() {
        FilePathResources.checkInitialize();
        return sdkPath + PACKAGE_MANAGER_SUFFIX;
    }

    static {
        isInitialized = false;
    }
}

