/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.emulator.manager.vms;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import org.tizen.emulator.manager.Messages;
import org.tizen.emulator.manager.concurrent.SimpleExecutor;
import org.tizen.emulator.manager.logging.EMLogger;
import org.tizen.emulator.manager.resources.FilePathResources;
import org.tizen.emulator.manager.resources.StringResources;
import org.tizen.emulator.manager.vms.Creator;
import org.tizen.emulator.manager.vms.IVMWorker;
import org.tizen.emulator.manager.vms.Modifier;
import org.tizen.emulator.manager.vms.VMLauncher;
import org.tizen.emulator.manager.vms.VMProperty;
import org.tizen.emulator.manager.vms.VMPropertyValue;
import org.tizen.emulator.manager.vms.exception.VMLauncherException;
import org.tizen.emulator.manager.vms.exception.VMWorkerException;
import org.tizen.emulator.manager.vms.helper.QemuImgProc;
import org.tizen.emulator.manager.vms.monitor.VMRunningChecker;
import org.tizen.emulator.manager.vms.option.IOption;

public class VMWorkerCommon
implements IVMWorker {
    private static final String VM_WORKER_COMMON_DELETE_ERROR = Messages.getString("VMWorkerCommon.DeleteError.0");
    private static final String VM_WORKER_COMMON_DUMMY_PLATFORM = Messages.getString("VMWorkerCommon.Message.Dummy.Platform");
    private VMProperty property;

    protected VMWorkerCommon() {
        EMLogger.getLogger().info("called VMWorkerCommon.");
    }

    @Deprecated
    protected void sendRemoteLog(String msg) {
        EMLogger.getLogger().info("called sendRemoteLog");
    }

    @Override
    public void initLauncher() {
        EMLogger.getLogger().info("called initLauncher of VMWorkerCommon.");
    }

    void setVMProperty(VMProperty property) {
        this.property = property;
    }

    @Override
    public void launchVM() throws VMLauncherException, VMWorkerException {
        this.launchVM(false, null);
    }

    public void launchVM(boolean wait, String path) throws VMLauncherException, VMWorkerException {
        this.launchVM(wait, path, null);
    }

    public void launchVM(final boolean wait, final String path, final List<String> overridingVars) throws VMWorkerException {
        try {
            SimpleExecutor.lockedExecute(new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    VMWorkerCommon.this.LaunchVMLocked(wait, path, overridingVars);
                    return null;
                }
            });
        }
        catch (VMWorkerException e) {
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
            EMLogger.printStackTrace(e);
        }
    }

    private void LaunchVMLocked(boolean wait, String path, List<String> overridingVars) throws VMWorkerException {
        if (Files.notExists(this.property.getPropertyFile(), new LinkOption[0])) {
            throw new VMWorkerException(VM_WORKER_COMMON_DELETE_ERROR, true);
        }
        if (this.property.getPropertyValue().getPlatform().isNotAvailabale()) {
            throw new VMWorkerException(VM_WORKER_COMMON_DUMMY_PLATFORM + " (" + this.property.getPropertyValue().getPlatformName() + ")");
        }
        List<IOption> optList = this.property.getPropertyValue().getOptionList();
        if (optList == null) {
            throw new VMLauncherException(Messages.getString("VMWorkerCommon.LaunchError.1"));
        }
        for (IOption option : optList) {
            option.checkArgument(this.property);
        }
        this.isRunningNow();
        boolean isSuccess = VMLauncher.launch(this.property, wait, path, overridingVars);
        if (!isSuccess) {
            throw new VMWorkerException("");
        }
    }

    @Override
    public void modifyVM(final VMPropertyValue newVM) throws VMWorkerException {
        try {
            SimpleExecutor.lockedExecute(new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    VMWorkerCommon.this.modifyVMLocked(newVM);
                    return null;
                }
            });
        }
        catch (VMWorkerException e) {
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
            EMLogger.printStackTrace(e);
        }
    }

    private void modifyVMLocked(VMPropertyValue newVM) throws VMWorkerException {
        if (Files.notExists(this.property.getPropertyFile(), new LinkOption[0])) {
            throw new VMWorkerException(VM_WORKER_COMMON_DELETE_ERROR, true);
        }
        if (this.property.getPropertyValue().getPlatform().isNotAvailabale()) {
            throw new VMWorkerException(VM_WORKER_COMMON_DUMMY_PLATFORM + " (" + this.property.getPropertyValue().getPlatformName() + ")");
        }
        this.isRunningNow();
        Modifier.modify(this.property, newVM);
    }

    @Override
    public void createNewBaseImage(VMProperty property, String dest, final boolean useCompress) throws VMWorkerException {
        final ArrayList<String> cmd = new ArrayList<String>();
        final String baseImagePartPath = dest + ".part";
        File propertyLockFile = null;
        try {
            propertyLockFile = SimpleExecutor.lockedExecute(new Callable<File>(){

                @Override
                public File call() throws Exception {
                    return VMWorkerCommon.this.createNewBaseImageLocked(baseImagePartPath, cmd, useCompress);
                }
            });
        }
        catch (VMWorkerException e) {
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
            EMLogger.printStackTrace(e);
        }
        this.createNewBaseImageUnlocked(cmd, dest, baseImagePartPath, propertyLockFile);
    }

    private File createNewBaseImageLocked(String baseImagePartPath, List<String> cmd, boolean useCompress) throws VMWorkerException {
        File propertyLockFile = null;
        if (!this.property.getPropertyValue().useQCOW2()) {
            throw new VMWorkerException("Cannot create base image because this VM is using raw disk image.");
        }
        if (this.property.getPropertyValue().getPlatform().isNotAvailabale()) {
            throw new VMWorkerException(VM_WORKER_COMMON_DUMMY_PLATFORM + " (" + this.property.getPropertyValue().getPlatformName() + ")");
        }
        if (Files.notExists(this.property.getPropertyFile(), new LinkOption[0])) {
            throw new VMWorkerException(VM_WORKER_COMMON_DELETE_ERROR, true);
        }
        File childImage = new File(this.property.getPropertyValue().childImagePath);
        File baseImage = new File(this.property.getPropertyValue().getDiskImagePath());
        if (!childImage.exists()) {
            throw new VMWorkerException(Messages.getString("VMWorkerCommon.Error.0") + childImage.getAbsolutePath());
        }
        if (!baseImage.exists()) {
            throw new VMWorkerException(Messages.getString("VMWorkerCommon.Error.0") + baseImage.getAbsolutePath());
        }
        propertyLockFile = new File(FilePathResources.getTizenSDKDataVmsPath() + File.separator + this.property.getPropertyValue().vmName + ".lock");
        try {
            propertyLockFile.createNewFile();
        }
        catch (IOException e) {
            EMLogger.getLogger().warning(e.getMessage());
        }
        String exe_path = FilePathResources.getEmulatorQemuImgPath();
        cmd.add(exe_path);
        cmd.add("convert");
        cmd.add("-O");
        cmd.add("qcow2");
        if (useCompress) {
            cmd.add("-c");
        }
        cmd.add(childImage.getAbsolutePath());
        cmd.add(baseImagePartPath);
        EMLogger.getLogger().info("Start creating new base image" + (useCompress ? " using compress." : "."));
        this.property.setState(VMProperty.State.BUSY);
        return propertyLockFile;
    }

    private void createNewBaseImageUnlocked(List<String> cmd, String baseImagePath, String baseImagePartPath, File propertyLockFile) throws VMWorkerException {
        QemuImgProc proc = new QemuImgProc(cmd);
        if (!proc.running()) {
            EMLogger.getLogger().info("Failed to create base image." + StringResources.NEW_LINE + "Base image path: " + baseImagePath);
            VMWorkerCommon.deleteFile(new File(baseImagePartPath));
            throw new VMWorkerException(Messages.getString("VMWorkerCommon.Qemu-imgError.0") + StringResources.NEW_LINE + Messages.getString("VMWorkerCommon.Qemu-imgError.1") + FilePathResources.getTizenSDKDataVmsPath() + File.separator + "emulator-manager)");
        }
        File baseFile = new File(baseImagePath);
        File partFile = new File(baseImagePartPath);
        if (baseFile.exists()) {
            EMLogger.getLogger().fine("Base image file is already exist. So, this file will be deleted.");
            if (!baseFile.delete()) {
                EMLogger.getLogger().warning("Failed to delete directory " + baseFile.getAbsolutePath());
            }
        }
        if (!partFile.renameTo(baseFile)) {
            VMWorkerCommon.deleteFile(baseFile);
            VMWorkerCommon.deleteFile(partFile);
            String error = "Failed to rename base image file. Please, try again to create base image.";
            EMLogger.getLogger().warning(error);
            throw new VMWorkerException(error);
        }
        if (propertyLockFile != null) {
            EMLogger.getLogger().fine("Delete property lock file.");
            if (!propertyLockFile.delete()) {
                EMLogger.getLogger().warning("Failed to delete directory " + propertyLockFile.getAbsolutePath());
            }
        }
        this.property.setState(VMProperty.State.RELEASE_BUSY);
        EMLogger.getLogger().info("Success to create base image." + StringResources.NEW_LINE + "Base image path: " + baseImagePath);
    }

    @Override
    public boolean deleteVM() throws VMWorkerException {
        boolean result = true;
        try {
            result = SimpleExecutor.lockedExecute(new Callable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    return VMWorkerCommon.this.deleteVMLocked();
                }
            });
        }
        catch (VMWorkerException e) {
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
            EMLogger.printStackTrace(e);
        }
        return result;
    }

    public boolean deleteVMLocked() throws VMWorkerException {
        boolean result = true;
        Path vmDirectory = null;
        try {
            if (Files.notExists(this.property.getPropertyFile(), new LinkOption[0])) {
                throw new VMWorkerException(VM_WORKER_COMMON_DELETE_ERROR, true);
            }
            this.isRunningNow();
            vmDirectory = this.property.getPropertyFile().resolve("..").normalize();
            if (!Files.isDirectory(vmDirectory, new LinkOption[0])) {
                throw new VMWorkerException(Messages.getString("VMWorkerCommon.PathError.0") + StringResources.NEW_LINE + vmDirectory);
            }
            Files.walkFileTree(vmDirectory, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    Files.delete(file);
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                    Files.delete(dir);
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException e) {
            e.printStackTrace();
            EMLogger.printStackTrace(e);
            String message = Messages.getString("MessageDialog.RemoveError.0") + this.property.getPropertyValue().vmName + Messages.getString("MessageDialog.RemoveError.1") + Messages.getString("MessageDialog.RemoveError.2") + Messages.getString("MessageDialog.RemoveError.3") + "[ " + vmDirectory + " ]";
            throw new VMWorkerException(message, true);
        }
        return result;
    }

    @Override
    public void resetVM() throws VMWorkerException {
        try {
            SimpleExecutor.lockedExecute(new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    VMWorkerCommon.this.resetVMLocked();
                    return null;
                }
            });
        }
        catch (VMWorkerException e) {
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
            EMLogger.printStackTrace(e);
        }
    }

    public void resetVMLocked() throws VMWorkerException {
        if (!this.property.getPropertyValue().useQCOW2()) {
            throw new VMWorkerException("Cannot reset this VM because this VM is using raw disk image.");
        }
        if (Files.notExists(this.property.getPropertyFile(), new LinkOption[0])) {
            throw new VMWorkerException(VM_WORKER_COMMON_DELETE_ERROR, true);
        }
        if (this.property.getPropertyValue().getPlatform().isNotAvailabale()) {
            throw new VMWorkerException(VM_WORKER_COMMON_DUMMY_PLATFORM + " (" + this.property.getPropertyValue().getPlatformName() + ")");
        }
        this.isRunningNow();
        String basePath = this.property.getPropertyValue().getDiskImagePath();
        String targetPath = this.property.getPropertyValue().childImagePath;
        if (basePath == null || basePath.isEmpty()) {
            throw new VMWorkerException(Messages.getString("VMWorkerCommon.PathError.1"));
        }
        if (targetPath == null || targetPath.isEmpty()) {
            throw new VMWorkerException(Messages.getString("VMWorkerCommon.PathError.2"));
        }
        File oldImageFile = new File(targetPath);
        if (oldImageFile.exists() && !oldImageFile.delete()) {
            EMLogger.getLogger().warning("Failed to delete " + oldImageFile.getAbsolutePath());
        }
        Creator.createInitialVMImage(basePath, targetPath);
        String swapTargetPath = this.property.getPropertyValue().swapImagePath;
        if (swapTargetPath != null) {
            String swapBasePath = FilePathResources.getToolEmulatorSwapImagePath() + File.separator + "swap.img";
            if (!new File(swapBasePath).exists()) {
                return;
            }
            if (swapTargetPath.isEmpty()) {
                throw new VMWorkerException(Messages.getString("VMWorkerCommon.PathError.3"));
            }
            File oldSwapFile = new File(swapTargetPath);
            if (oldSwapFile.exists() && !oldSwapFile.delete()) {
                EMLogger.getLogger().warning("Failed to delete " + oldSwapFile.getAbsolutePath());
            }
            Creator.createSwapImage(swapBasePath, swapTargetPath);
        }
    }

    @Override
    public void cloneVM(String newVMName) throws VMWorkerException {
        VMPropertyValue newValue = this.property.getPropertyValue();
        newValue.vmName = newVMName;
        Creator.create(newValue);
    }

    public boolean isRunningNow() throws VMWorkerException {
        File file = new File(FilePathResources.getTizenSDKDataVmsPath() + File.separator + this.property.getPropertyValue().vmName + ".lock");
        if (file.exists()) {
            throw new VMWorkerException("[" + this.property.getPropertyValue().vmName + "]" + Messages.getString("VMWorkerCommon.WorkingError.0"));
        }
        if (VMWorkerCommon.checking(this.property)) {
            throw new VMWorkerException("[" + this.property.getPropertyValue().vmName + Messages.getString("VMWorkerCommon.WorkingError.1"));
        }
        return false;
    }

    public static boolean checking(VMProperty prop) {
        boolean result = false;
        result = VMRunningChecker.isRunning(prop);
        return result;
    }

    public static boolean deleteFile(File file) {
        boolean result = true;
        if (!file.exists()) {
            return result;
        }
        if (file.isDirectory()) {
            File[] allFiles = file.listFiles();
            if (allFiles != null) {
                for (File f : allFiles) {
                    if (VMWorkerCommon.deleteFile(f)) continue;
                    result = false;
                }
            }
            if (!file.delete()) {
                result = false;
            }
        } else if (!file.delete()) {
            result = false;
        }
        return result;
    }
}

