/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.emulator.manager.console;

import org.tizen.emulator.manager.console.Command;
import org.tizen.emulator.manager.console.Option;
import org.tizen.emulator.manager.console.processor.ConsoleProcessor;
import org.tizen.emulator.manager.console.resources.Messages;
import org.tizen.emulator.manager.console.resources.StringResources;

class Detail
extends Command {
    public Detail() {
        this.commandString = "detail";
        this.shortDescription = Messages.getString("Detail.ShortDescription");
        this.description = Messages.getString("Detail.Description.1") + StringResources.NEW_LINE + Messages.getString("Detail.Description.2");
        this.usage = Messages.getString("Detail.Usage.1") + StringResources.NEW_LINE + Messages.getString("Detail.Usage.2") + StringResources.NEW_LINE + Messages.getString("Detail.Usage.3") + StringResources.NEW_LINE + Messages.getString("Detail.Usage.4");
        this.optionList.add(new Option("n", "name", StringResources.DESC_DETAIL_NAME, "", false, true, "NAME"));
    }

    @Override
    public boolean process() {
        ConsoleProcessor processor = new ConsoleProcessor();
        String name = null;
        for (Option c : this.optionList) {
            if (!c.isInCommandLine()) continue;
            switch (c.getShortName().charAt(0)) {
                case 'n': {
                    name = c.getCurrentValue();
                    break;
                }
            }
        }
        if (name != null) {
            processor.printDetailOfVM(name);
        } else {
            processor.printAboutInfo();
        }
        return true;
    }
}

