/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.emulator.manager.vms.option;

import java.io.File;
import org.tizen.emulator.manager.vms.VMProperty;
import org.tizen.emulator.manager.vms.option.LaunchConfig;
import org.tizen.emulator.manager.vms.option.OPTION_KEY;
import org.tizen.emulator.manager.vms.option.Option;

public class BaseImageOption
extends Option {
    private static final String IF_PREFIX = "if";
    private static final String NONE_PREFIX = "none";
    private static final String INDEX_PREFIX = "index";
    private static final String DRIVE_OPTION = "-drive";
    private static final String DEVICE_OPTION = "-device";

    @Override
    public void getLaunchArgument(LaunchConfig config, VMProperty property) {
        if (property.getPropertyValue().getPlatform() != null) {
            config.addVariable(OPTION_KEY.VAR_IMAGE_VER, property.getPropertyValue().getImageBinaryVersion());
        }
        int driveIndex = 0;
        if (property.getPropertyValue().useQCOW2()) {
            config.addVariableWithSpace(OPTION_KEY.VAR_DRIVE, "file=${vms_path}" + File.separator + "${vm_name}" + File.separator + "emulimg-${vm_name}." + BaseImageOption.varForm(OPTION_KEY.VAR_IMAGE_ARCH) + "," + IF_PREFIX + "=" + NONE_PREFIX + "," + INDEX_PREFIX + "=" + driveIndex++ + ",cache.no-flush=on");
            config.addQemuOption(DRIVE_OPTION, BaseImageOption.varForm(OPTION_KEY.VAR_DRIVE) + ",id=drive");
            config.addQemuOption(DEVICE_OPTION, "virtio-blk-pci,drive=drive");
        } else {
            for (String rawImagePath : property.getPropertyValue().getImagePathList()) {
                String varDrive = OPTION_KEY.VAR_DRIVE.toString();
                if (driveIndex > 0) {
                    varDrive = varDrive + String.valueOf(driveIndex);
                }
                config.addVariableWithSpace(varDrive, "file=" + rawImagePath + "," + IF_PREFIX + "=" + NONE_PREFIX + "," + INDEX_PREFIX + "=" + driveIndex + ",cache.no-flush=on,format=raw");
                config.addQemuOption(DRIVE_OPTION, BaseImageOption.varForm(varDrive) + ",id=" + varDrive);
                config.addQemuOption(DEVICE_OPTION, "virtio-blk-pci,drive=" + varDrive);
                ++driveIndex;
            }
        }
        config.addVariableWithSpace(OPTION_KEY.VAR_SWAP, "file=${vms_path}" + File.separator + "${vm_name}" + File.separator + "swap-${vm_name}.img," + IF_PREFIX + "=" + NONE_PREFIX + "," + INDEX_PREFIX + "=" + driveIndex);
        config.addQemuOption(DRIVE_OPTION, BaseImageOption.varForm(OPTION_KEY.VAR_SWAP) + ",id=swap");
        config.addQemuOption(DEVICE_OPTION, "virtio-blk-pci,drive=swap");
    }
}

