/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.emulator.manager.ui.resources;

import java.io.InputStream;
import javafx.scene.text.Font;
import org.tizen.emulator.manager.logging.EMLogger;
import org.tizen.emulator.manager.ui.Main;
import org.tizen.emulator.manager.ui.resources.Supplier;

class FontSupplier
implements Supplier<Font> {
    private final String name;
    private final double size;

    public FontSupplier(String name, double size) {
        this.name = name;
        this.size = size;
    }

    @Override
    public Font get() {
        ClassLoader loader = null;
        loader = Main.class.getClassLoader();
        InputStream is = loader.getResourceAsStream("font/" + this.name + ".ttf");
        Font font = Font.loadFont((InputStream)is, (double)this.size);
        if (font == null) {
            font = new Font(this.size);
            EMLogger.getLogger().warning("Font.loadFont() for [" + this.name + ", " + this.size + "] returns null. Use default font.");
        }
        return font;
    }
}

